/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Material;
import org.bukkit.entity.WaterMob;
import org.bukkit.util.Vector;

public class SwimmingExaminer
implements BlockExaminer {
    private boolean canSwimInLava;
    private final NPC npc;

    public SwimmingExaminer(NPC npc) {
        this.npc = npc;
    }

    public boolean canSwimInLava() {
        return this.canSwimInLava;
    }

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        if (SpigotUtil.isUsing1_13API() && this.npc.getEntity() instanceof WaterMob) {
            Vector vector = point.getVector();
            if (!MinecraftBlockExaminer.isLiquidOrInLiquid(source.getWorld().getBlockAt(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ()))) {
                return 0.5f;
            }
        }
        return 0.0f;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        BlockExaminer.PassableState canSwim;
        Vector vector = point.getVector();
        if (!MinecraftBlockExaminer.isLiquidOrInLiquid(source.getWorld().getBlockAt(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ()))) {
            return BlockExaminer.PassableState.IGNORE;
        }
        if (SpigotUtil.isUsing1_13API() && this.npc.getEntity() instanceof WaterMob) {
            return BlockExaminer.PassableState.PASSABLE;
        }
        Material above = source.getMaterialAt(vector.add(new Vector(0, 1, 0)));
        BlockExaminer.PassableState passableState = canSwim = this.isSwimmableLiquid(above) || MinecraftBlockExaminer.canStandIn(above) ? BlockExaminer.PassableState.PASSABLE : BlockExaminer.PassableState.UNPASSABLE;
        if (point.getParentPoint() == null) {
            return canSwim;
        }
        if (vector.getBlockY() < point.getParentPoint().getVector().getBlockY()) {
            if (!this.isSwimmableLiquid(source.getMaterialAt(point.getParentPoint().getVector()))) {
                return canSwim;
            }
            return this.isSwimming() ? BlockExaminer.PassableState.UNPASSABLE : BlockExaminer.PassableState.PASSABLE;
        }
        return canSwim;
    }

    private boolean isSwimmableLiquid(Material material) {
        if (material == Material.LAVA || !SpigotUtil.isUsing1_13API() && material == Material.valueOf((String)"STATIONARY_LAVA")) {
            return this.canSwimInLava();
        }
        return material == Material.WATER || !SpigotUtil.isUsing1_13API() && material == Material.valueOf((String)"STATIONARY_WATER");
    }

    public boolean isSwimming() {
        return this.npc.data().get("swim", true);
    }

    public void setCanSwimInLava(boolean canSwimInLava) {
        this.canSwimInLava = canSwimInLava;
    }
}

