/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.citizensnpcs.api.jnbt.ByteTag;
import net.citizensnpcs.api.jnbt.CompoundTag;
import net.citizensnpcs.api.jnbt.DoubleTag;
import net.citizensnpcs.api.jnbt.FloatTag;
import net.citizensnpcs.api.jnbt.IntTag;
import net.citizensnpcs.api.jnbt.LongTag;
import net.citizensnpcs.api.jnbt.NBTInputStream;
import net.citizensnpcs.api.jnbt.NBTOutputStream;
import net.citizensnpcs.api.jnbt.NBTUtils;
import net.citizensnpcs.api.jnbt.ShortTag;
import net.citizensnpcs.api.jnbt.StringTag;
import net.citizensnpcs.api.jnbt.Tag;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.FileStorage;
import net.citizensnpcs.api.util.Messaging;

public class NBTStorage
implements FileStorage {
    private final File file;
    private final String name;
    private final Map<String, Tag> root = Maps.newHashMap();

    public NBTStorage(File file) {
        this(file, "root");
    }

    public NBTStorage(File file, String name) {
        this.file = file;
        if (!this.file.exists()) {
            this.create();
        }
        this.name = name;
    }

    public NBTStorage(String file) {
        this(new File(file), "root");
    }

    private void create() {
        try {
            Messaging.log("Creating file: " + this.file.getName());
            Files.createParentDirs((File)this.file);
            this.file.createNewFile();
        }
        catch (IOException ex) {
            Messaging.severe("Could not create file: " + this.file.getName());
            ex.printStackTrace();
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public NBTKey getKey(String root) {
        return new NBTKey(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load() {
        NBTInputStream stream = null;
        try {
            stream = new NBTInputStream(new GZIPInputStream(new FileInputStream(this.file)));
            Tag tag = stream.readTag();
            if (tag == null || !(tag instanceof CompoundTag)) {
                boolean bl = false;
                return bl;
            }
            this.root.clear();
            this.root.putAll((Map<String, Tag>)((CompoundTag)tag).getValue());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {
                e.getCause();
            }
        }
        return true;
    }

    @Override
    public void save() {
        NBTOutputStream stream = null;
        try {
            Files.createParentDirs((File)this.file);
            File temporaryFile = File.createTempFile(this.file.getName(), null, this.file.getParentFile());
            temporaryFile.deleteOnExit();
            stream = new NBTOutputStream(new FileOutputStream(temporaryFile));
            stream.writeTag(new CompoundTag(this.name, this.root));
            stream.close();
            this.file.delete();
            temporaryFile.renameTo(this.file);
            temporaryFile.delete();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {
                e.getCause();
            }
        }
    }

    public String toString() {
        return "NBTStorage {file=" + this.file + "}";
    }

    public class NBTKey
    extends DataKey {
        public NBTKey(String root) {
            super(root);
        }

        private String createRelativeKey(String parent, String sub) {
            if (sub.isEmpty()) {
                return parent;
            }
            if (sub.charAt(0) == '.') {
                return parent.isEmpty() ? sub.substring(1, sub.length()) : parent + sub;
            }
            return parent.isEmpty() ? sub : parent + "." + sub;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NBTKey other = (NBTKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        private Number extractNumber(Tag tag) {
            if (tag == null) {
                return null;
            }
            if (tag instanceof DoubleTag) {
                return ((DoubleTag)tag).getValue();
            }
            if (tag instanceof IntTag) {
                return ((IntTag)tag).getValue();
            }
            if (tag instanceof ShortTag) {
                return ((ShortTag)tag).getValue();
            }
            if (tag instanceof ByteTag) {
                return ((ByteTag)tag).getValue();
            }
            if (tag instanceof FloatTag) {
                return ((FloatTag)tag).getValue();
            }
            if (tag instanceof LongTag) {
                return ((LongTag)tag).getValue();
            }
            return null;
        }

        private Map<String, Tag> findLastParent(String[] parts) {
            Object map = NBTStorage.this.root;
            for (int i = 0; i < parts.length - 1; ++i) {
                if (!map.containsKey(parts[i]) || !(map.get(parts[i]) instanceof CompoundTag)) {
                    return Collections.emptyMap();
                }
                map = ((CompoundTag)map.get(parts[i])).getValue();
            }
            return map;
        }

        private Tag findLastTag(String key) {
            return this.findLastTag(key, true);
        }

        private Tag findLastTag(String key, boolean relative) {
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').omitEmptyStrings().split((CharSequence)(relative ? this.createRelativeKey(key) : key)), String.class);
            if (parts.length == 0) {
                return new CompoundTag(NBTStorage.this.name, NBTStorage.this.root);
            }
            Map<String, Tag> map = this.findLastParent(parts);
            if (!map.containsKey(parts[parts.length - 1])) {
                return null;
            }
            return map.get(parts[parts.length - 1]);
        }

        @Override
        public boolean getBoolean(String key) {
            Number number = this.extractNumber(this.findLastTag(key));
            if (number == null) {
                return false;
            }
            return number.byteValue() >= 1;
        }

        @Override
        public double getDouble(String key) {
            Number number = this.extractNumber(this.findLastTag(key));
            if (number == null) {
                return 0.0;
            }
            return number.doubleValue();
        }

        @Override
        public DataKey getFromRoot(String path) {
            return new NBTKey(path);
        }

        @Override
        public int getInt(String key) {
            Number number = this.extractNumber(this.findLastTag(key));
            if (number == null) {
                return 0;
            }
            return number.intValue();
        }

        @Override
        public long getLong(String key) {
            Number number = this.extractNumber(this.findLastTag(key));
            if (number == null) {
                return 0L;
            }
            return number.longValue();
        }

        private String getNameFor(String key) {
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').split((CharSequence)this.createRelativeKey(key)), String.class);
            return parts[parts.length - 1];
        }

        private NBTStorage getOuterType() {
            return NBTStorage.this;
        }

        @Override
        public Object getRaw(String key) {
            Tag tag = this.findLastTag(key);
            if (tag == null) {
                return null;
            }
            return tag.getValue();
        }

        @Override
        public DataKey getRelative(String relative) {
            return new NBTKey(this.createRelativeKey(relative));
        }

        @Override
        public String getString(String key) {
            Tag tag = this.findLastTag(key);
            if (tag == null || !(tag instanceof StringTag)) {
                return "";
            }
            return ((StringTag)tag).getValue();
        }

        @Override
        public Iterable<DataKey> getSubKeys() {
            Tag tag = this.findLastTag(this.path, false);
            if (!(tag instanceof CompoundTag)) {
                return Collections.emptyList();
            }
            ArrayList subKeys = Lists.newArrayList();
            for (String name : ((CompoundTag)tag).getValue().keySet()) {
                subKeys.add(new NBTKey(this.createRelativeKey(name)));
            }
            return subKeys;
        }

        @Override
        public Map<String, Object> getValuesDeep() {
            Tag tag = this.findLastTag(this.path, false);
            if (!(tag instanceof CompoundTag)) {
                return Collections.emptyMap();
            }
            ArrayDeque<Node> node = new ArrayDeque<Node>((Collection<Node>)ImmutableList.of((Object)new Node(tag)));
            HashMap values = Maps.newHashMap();
            while (!node.isEmpty()) {
                Node root = (Node)node.poll();
                for (Map.Entry<String, Tag> entry : root.values.entrySet()) {
                    String key = this.createRelativeKey(root.parent, entry.getKey());
                    if (entry.getValue() instanceof CompoundTag) {
                        node.add(new Node(key, entry.getValue()));
                        continue;
                    }
                    values.put(key, entry.getValue().getValue());
                }
            }
            return values;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        @Override
        public boolean keyExists(String key) {
            return this.findLastTag(this.createRelativeKey(key), false) != null;
        }

        @Override
        public String name() {
            int last = this.path.lastIndexOf(46);
            return this.path.substring(last == 0 ? 0 : last + 1);
        }

        private void putTag(String key, Tag tag) {
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').split((CharSequence)this.createRelativeKey(key)), String.class);
            Object parent = NBTStorage.this.root;
            for (int i = 0; i < parts.length - 1; ++i) {
                if (!parent.containsKey(parts[i]) || !(parent.get(parts[i]) instanceof CompoundTag)) {
                    parent.put(parts[i], new CompoundTag(parts[i]));
                }
                parent = ((CompoundTag)parent.get(parts[i])).getValue();
            }
            parent.put(tag.getName(), tag);
        }

        @Override
        public void removeKey(String key) {
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').split((CharSequence)this.createRelativeKey(key)), String.class);
            Map<String, Tag> parent = this.findLastParent(parts);
            parent.remove(parts[parts.length - 1]);
        }

        @Override
        public void setBoolean(String key, boolean value) {
            this.putTag(key, new ByteTag(this.getNameFor(key), (byte)(value ? 1 : 0)));
        }

        @Override
        public void setDouble(String key, double value) {
            this.putTag(key, new DoubleTag(this.getNameFor(key), value));
        }

        @Override
        public void setInt(String key, int value) {
            this.putTag(key, new IntTag(this.getNameFor(key), value));
        }

        @Override
        public void setLong(String key, long value) {
            this.putTag(key, new LongTag(this.getNameFor(key), value));
        }

        @Override
        public void setRaw(String key, Object value) {
            Tag tag = NBTUtils.createTag(this.getNameFor(key), value);
            if (tag == null) {
                throw new IllegalArgumentException("could not convert value to tag");
            }
            this.putTag(key, tag);
        }

        @Override
        public void setString(String key, String value) {
            this.putTag(key, new StringTag(this.getNameFor(key), value));
        }
    }

    private static class Node {
        final String parent;
        final Map<String, Tag> values;

        public Node(String parent, Tag tag) {
            this.parent = parent;
            this.values = ((CompoundTag)tag).getValue();
        }

        public Node(Tag tag) {
            this("", tag);
        }
    }
}

