/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class Placeholders {
    private static final Pattern PLACEHOLDER_MATCHER = Pattern.compile("<(id|npc|owner)>");
    private static boolean PLACEHOLDERAPI_ENABLED = true;
    private static final Pattern PLAYER_PLACEHOLDER_MATCHER = Pattern.compile("(<player>|<p>|@p|%player%|<random_player>|<random_npc>|<random_npc_id>|<nearest_player>|<world>)");
    private static final String[] PLAYER_PLACEHOLDERS = new String[]{"<player>", "<p>", "@p", "%player%"};
    private static final Collection<String> PLAYER_VARIABLES = ImmutableList.of((Object)"<player>", (Object)"<p>", (Object)"@p", (Object)"%player%");

    public static String replace(String text, CommandSender sender, NPC npc) {
        text = Placeholders.replace(text, sender instanceof OfflinePlayer ? (OfflinePlayer)sender : null);
        if (npc == null) {
            return text;
        }
        StringBuffer out = new StringBuffer();
        Matcher matcher = PLACEHOLDER_MATCHER.matcher(text);
        while (matcher.find()) {
            String replacement = "";
            String group = matcher.group(1);
            if (group.equals("id")) {
                replacement = Integer.toString(npc.getId());
            } else if (group.equals("npc")) {
                replacement = npc.getName();
            } else if (group.equals("owner")) {
                replacement = npc.getOrAddTrait(Owner.class).getOwner();
            }
            matcher.appendReplacement(out, "");
            out.append(replacement);
        }
        matcher.appendTail(out);
        return out.toString();
    }

    public static String replace(String text, OfflinePlayer player) {
        if (player == null) {
            return Placeholders.setPlaceholderAPIPlaceholders(text, player);
        }
        if (player instanceof Entity && ((Entity)player).isValid()) {
            StringBuffer out = new StringBuffer();
            Matcher matcher = PLAYER_PLACEHOLDER_MATCHER.matcher(text);
            while (matcher.find()) {
                String replacement = "";
                String group = matcher.group(1);
                if (PLAYER_VARIABLES.contains(group)) {
                    replacement = player.getName();
                } else if (group.equals("<random_player>")) {
                    Collection players = Bukkit.getServer().getOnlinePlayers();
                    Player possible = (Player)Iterables.get((Iterable)players, (int)new Random().nextInt(players.size()), null);
                    if (possible != null) {
                        replacement = possible.getName();
                    }
                } else if (group.equals("<random_npc>")) {
                    ArrayList all = Lists.newArrayList((Iterable)CitizensAPI.getNPCRegistry());
                    if (all.size() > 0) {
                        replacement = ((NPC)all.get(new Random().nextInt(all.size()))).getName();
                    }
                } else if (group.equals("<random_npc_id>")) {
                    ArrayList all = Lists.newArrayList((Iterable)CitizensAPI.getNPCRegistry());
                    if (all.size() > 0) {
                        replacement = Integer.toString(((NPC)all.get(new Random().nextInt(all.size()))).getId());
                    }
                } else if (group.equals("<nearest_player>")) {
                    double min = Double.MAX_VALUE;
                    Player closest = null;
                    for (Entity entity : ((Player)player).getNearbyEntities(25.0, 25.0, 25.0)) {
                        Location location;
                        double dist;
                        if (entity == player || !(entity instanceof Player) || entity.getType() != EntityType.PLAYER || CitizensAPI.getNPCRegistry().isNPC(entity) || (dist = (location = entity.getLocation()).distanceSquared(((Player)player).getLocation())) > min) continue;
                        min = dist;
                        closest = (Player)entity;
                    }
                    if (closest != null) {
                        replacement = closest.getName();
                    }
                } else if (group.equals("<world>")) {
                    replacement = ((Entity)player).getWorld().getName();
                }
                matcher.appendReplacement(out, "");
                out.append(replacement);
            }
            matcher.appendTail(out);
            text = out.toString();
        } else {
            for (int i = 0; i < PLAYER_PLACEHOLDERS.length; ++i) {
                text = text.replace(PLAYER_PLACEHOLDERS[i], player.getName());
            }
        }
        return Placeholders.setPlaceholderAPIPlaceholders(text, player);
    }

    private static String setPlaceholderAPIPlaceholders(String text, OfflinePlayer player) {
        if (!PLACEHOLDERAPI_ENABLED) {
            return text;
        }
        try {
            return PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)text);
        }
        catch (Throwable t) {
            PLACEHOLDERAPI_ENABLED = false;
            return text;
        }
    }
}

