/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.command;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.citizensnpcs.api.command.exception.CommandException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandContext {
    protected String[] args;
    protected final Set<Character> flags = new HashSet<Character>();
    private Location location = null;
    private final CommandSender sender;
    protected final Map<String, String> valueFlags = Maps.newHashMap();
    private static final Pattern FLAG = Pattern.compile("^-[a-zA-Z]+$");
    private static final Splitter LOCATION_SPLITTER = Splitter.on((Pattern)Pattern.compile("[,:]")).omitEmptyStrings();
    private static final Pattern VALUE_FLAG = Pattern.compile("^--[a-zA-Z0-9-]+$");

    public CommandContext(CommandSender sender, String[] args) {
        int i;
        this.sender = sender;
        block0: for (i = 1; i < args.length; ++i) {
            args[i] = args[i].trim();
            if (args[i].length() == 0 || args[i].charAt(0) != '\'' && args[i].charAt(0) != '\"' && args[i].charAt(0) != '`') continue;
            char quote = args[i].charAt(0);
            String quoted = args[i].substring(1);
            if (quoted.length() > 0 && quoted.charAt(quoted.length() - 1) == quote) {
                args[i] = quoted.substring(0, quoted.length() - 1);
                continue;
            }
            for (int inner = i + 1; inner < args.length; ++inner) {
                if (args[inner].isEmpty()) continue;
                String test = args[inner].trim();
                quoted = quoted + " " + test;
                if (test.charAt(test.length() - 1) != quote) continue;
                args[i] = quoted.substring(0, quoted.length() - 1);
                for (int j = i + 1; j <= inner; ++j) {
                    args[j] = "";
                }
                continue block0;
            }
        }
        for (i = 1; i < args.length; ++i) {
            int length = args[i].length();
            if (length == 0) continue;
            if (i + 1 < args.length && length > 2 && VALUE_FLAG.matcher(args[i]).matches()) {
                int inner = i + 1;
                while (args[inner].length() == 0) {
                    if (++inner < args.length) continue;
                    inner = -1;
                    break;
                }
                if (inner == -1) continue;
                this.valueFlags.put(args[i].toLowerCase().substring(2), args[inner]);
                args[i] = "";
                args[inner] = "";
                continue;
            }
            if (!FLAG.matcher(args[i]).matches()) continue;
            for (int k = 1; k < args[i].length(); ++k) {
                this.flags.add(Character.valueOf(args[i].charAt(k)));
            }
            args[i] = "";
        }
        ArrayList copied = Lists.newArrayList();
        for (String arg : args) {
            if ((arg = arg.trim()) == null || arg.isEmpty()) continue;
            copied.add(arg.trim());
        }
        this.args = copied.toArray(new String[copied.size()]);
    }

    public CommandContext(String[] args) {
        this(null, args);
    }

    public int argsLength() {
        return this.args.length - 1;
    }

    public String getCommand() {
        return this.args[0];
    }

    public double getDouble(int index) throws NumberFormatException {
        return Double.parseDouble(this.args[index + 1]);
    }

    public double getDouble(int index, double def) throws NumberFormatException {
        return index + 1 < this.args.length ? Double.parseDouble(this.args[index + 1]) : def;
    }

    public String getFlag(String ch) {
        return this.valueFlags.get(ch);
    }

    public String getFlag(String ch, String def) {
        String value = this.valueFlags.get(ch);
        if (value == null) {
            return def;
        }
        return value;
    }

    public double getFlagDouble(String ch) throws NumberFormatException {
        return Double.parseDouble(this.valueFlags.get(ch));
    }

    public double getFlagDouble(String ch, double def) throws NumberFormatException {
        String value = this.valueFlags.get(ch);
        if (value == null) {
            return def;
        }
        return Double.parseDouble(value);
    }

    public int getFlagInteger(String ch) throws NumberFormatException {
        return Integer.parseInt(this.valueFlags.get(ch));
    }

    public int getFlagInteger(String ch, int def) throws NumberFormatException {
        String value = this.valueFlags.get(ch);
        if (value == null) {
            return def;
        }
        return Integer.parseInt(value);
    }

    public Set<Character> getFlags() {
        return this.flags;
    }

    public int getInteger(int index) throws NumberFormatException {
        return Integer.parseInt(this.args[index + 1]);
    }

    public int getInteger(int index, int def) throws NumberFormatException {
        if (index + 1 < this.args.length) {
            try {
                return Integer.parseInt(this.args[index + 1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public String getJoinedStrings(int initialIndex) {
        return this.getJoinedStrings(initialIndex, ' ');
    }

    public String getJoinedStrings(int initialIndex, char delimiter) {
        StringBuilder buffer = new StringBuilder(this.args[++initialIndex]);
        for (int i = initialIndex + 1; i < this.args.length; ++i) {
            buffer.append(delimiter).append(this.args[i]);
        }
        return buffer.toString().trim();
    }

    public String[] getPaddedSlice(int index, int padding) {
        String[] slice = new String[this.args.length - index + padding];
        System.arraycopy(this.args, index, slice, padding, this.args.length - index);
        return slice;
    }

    public Location getSenderLocation() throws CommandException {
        if (this.location != null || this.sender == null) {
            return this.location;
        }
        if (this.hasValueFlag("location")) {
            return CommandContext.parseLocation(this.location, this.getFlag("location"));
        }
        if (this.sender instanceof Player) {
            this.location = ((Player)this.sender).getLocation();
        } else if (this.sender instanceof BlockCommandSender) {
            this.location = ((BlockCommandSender)this.sender).getBlock().getLocation();
        }
        return this.location;
    }

    public Location getSenderTargetBlockLocation() throws CommandException {
        if (this.sender == null) {
            return this.location;
        }
        if (this.hasValueFlag("location")) {
            return CommandContext.parseLocation(this.location, this.getFlag("location"));
        }
        if (this.sender instanceof Player) {
            this.location = ((Player)this.sender).getTargetBlock((Set)null, 50).getLocation();
        } else if (this.sender instanceof BlockCommandSender) {
            this.location = ((BlockCommandSender)this.sender).getBlock().getLocation();
        }
        return this.location;
    }

    public String[] getSlice(int index) {
        String[] slice = new String[this.args.length - index - 1];
        System.arraycopy(this.args, index + 1, slice, 0, this.args.length - index - 1);
        return slice;
    }

    public String getString(int index) {
        return this.args[index + 1];
    }

    public String getString(int index, String def) {
        return index + 1 < this.args.length ? this.args[index + 1] : def;
    }

    public Map<String, String> getValueFlags() {
        return this.valueFlags;
    }

    public boolean hasAnyFlags() {
        return this.valueFlags.size() > 0 || this.flags.size() > 0;
    }

    public boolean hasAnyValueFlag(String ... strings) {
        for (String s : strings) {
            if (!this.hasValueFlag(s)) continue;
            return true;
        }
        return false;
    }

    public boolean hasFlag(char ch) {
        return this.flags.contains(Character.valueOf(ch));
    }

    public boolean hasValueFlag(String ch) {
        return this.valueFlags.containsKey(ch);
    }

    public int length() {
        return this.args.length;
    }

    public boolean matches(String command) {
        return this.args[0].equalsIgnoreCase(command);
    }

    public static Location parseLocation(Location currentLocation, String flag) throws CommandException {
        boolean denizen = flag.startsWith("l@");
        String[] parts = (String[])Iterables.toArray((Iterable)LOCATION_SPLITTER.split((CharSequence)flag.replaceFirst("l@", "")), String.class);
        if (parts.length > 0) {
            String worldName = currentLocation != null ? currentLocation.getWorld().getName() : "";
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            float yaw = 0.0f;
            float pitch = 0.0f;
            switch (parts.length) {
                case 6: {
                    if (denizen) {
                        worldName = parts[5].replaceFirst("w@", "");
                    } else {
                        pitch = Float.parseFloat(parts[5]);
                    }
                }
                case 5: {
                    if (denizen) {
                        pitch = Float.parseFloat(parts[4]);
                    } else {
                        yaw = Float.parseFloat(parts[4]);
                    }
                }
                case 4: {
                    if (denizen && parts.length > 4) {
                        yaw = Float.parseFloat(parts[3]);
                    } else {
                        worldName = parts[3].replaceFirst("w@", "");
                    }
                }
                case 3: {
                    x = Double.parseDouble(parts[0]);
                    y = Double.parseDouble(parts[1]);
                    z = Double.parseDouble(parts[2]);
                    break;
                }
                default: {
                    throw new CommandException("citizens.commands.npc.create.invalid-location");
                }
            }
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                throw new CommandException("citizens.commands.npc.create.invalid-location");
            }
            return new Location(world, x, y, z, yaw, pitch);
        }
        Player search = Bukkit.getPlayerExact((String)flag);
        if (search == null) {
            throw new CommandException("citizens.commands.npc.create.no-player-for-spawn");
        }
        return search.getLocation();
    }
}

