/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.persistence;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.lang.ref.WeakReference;
import java.util.Map;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.util.DataKey;

public class PersisterRegistry<T>
implements Persister<T> {
    private final Map<String, WeakReference<Class<? extends T>>> registry = Maps.newHashMap();

    PersisterRegistry() {
    }

    @Override
    public T create(DataKey root) {
        String type = root.getString("type");
        WeakReference<Class<T>> clazz = this.registry.get(type);
        if (clazz == null) {
            throw new IllegalStateException("missing registration for type " + type);
        }
        return (T)PersistenceLoader.load((Class)clazz.get(), root);
    }

    public void register(String type, Class<? extends T> clazz) {
        this.registry.put(type, new WeakReference<Class<? extends T>>(clazz));
    }

    public Iterable<Class<? extends T>> registeredTypes() {
        return Iterables.transform(this.registry.values(), ref -> (Class)ref.get());
    }

    @Override
    public void save(T instance, DataKey root) {
        PersistenceLoader.save(instance, root);
        Class<?> clazz = instance.getClass();
        for (Map.Entry<String, WeakReference<Class<T>>> entry : this.registry.entrySet()) {
            if (clazz != entry.getValue().get()) continue;
            root.setString("type", entry.getKey());
            return;
        }
        throw new IllegalStateException("missing registration for instance " + instance);
    }
}

