/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.flocking;

import java.util.Collection;
import net.citizensnpcs.api.ai.flocking.FlockBehavior;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class CohesionBehavior
implements FlockBehavior {
    private final double weight;
    private static final Location CACHE = new Location(null, 0.0, 0.0, 0.0);

    public CohesionBehavior(double weight) {
        this.weight = weight;
    }

    @Override
    public Vector getVector(NPC npc, Collection<NPC> nearby) {
        Vector positions = new Vector(0, 0, 0);
        for (NPC neighbor : nearby) {
            positions = positions.add(neighbor.getEntity().getLocation(CACHE).toVector());
        }
        Vector center = positions.multiply(1.0 / (double)nearby.size());
        Vector temp = npc.getEntity().getLocation(CACHE).toVector().subtract(center);
        if (temp.length() == 0.0) {
            return new Vector(0, 0, 0);
        }
        return temp.normalize().multiply(this.weight);
    }
}

