/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.gui;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.citizensnpcs.api.gui.CitizensInventoryClickEvent;
import net.citizensnpcs.api.gui.ClickHandler;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.gui.MenuSlot;
import net.citizensnpcs.api.util.Colorizer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InputMenus {
    public static InventoryMenuPage filteredStringSetter(Supplier<String> initialValue, Function<String, Boolean> callback) {
        return new StringInputMenu(initialValue, callback);
    }

    public static <T> InventoryMenuPage picker(String title, Consumer<Choice<T>> callback, Choice<T> ... choices) {
        return new ChoiceInputMenu(title, Choice.Type.PICKER, chosen -> callback.accept(chosen.size() > 0 ? (Choice)chosen.get(0) : null), choices);
    }

    public static InventoryMenuPage stringSetter(Supplier<String> initialValue, Consumer<String> callback) {
        return new StringInputMenu(initialValue, (Function<String, Boolean>)((Function)s -> {
            callback.accept((String)s);
            return true;
        }));
    }

    public static <T> InventoryMenuPage toggle(String title, Consumer<List<Choice<T>>> callback, Choice<T> ... choices) {
        return new ChoiceInputMenu<T>(title, Choice.Type.TOGGLE, callback, choices);
    }

    @Menu(type=InventoryType.ANVIL)
    private static class StringInputMenu
    extends InventoryMenuPage {
        private final Function<String, Boolean> callback;
        private MenuContext ctx;
        @MenuSlot(slot={0, 0}, material=Material.PAPER, amount=1)
        private InventoryMenuSlot from;
        private final Supplier<String> initialValue;

        public StringInputMenu(Supplier<String> initialValue, Function<String, Boolean> callback) {
            this.initialValue = initialValue;
            this.callback = callback;
        }

        @ClickHandler(slot={0, 0})
        public void cancel(InventoryMenuSlot slot, CitizensInventoryClickEvent evt) {
            evt.setCancelled(true);
            this.ctx.getMenu().transitionBack();
        }

        @Override
        public void initialise(MenuContext ctx) {
            this.ctx = ctx;
            ItemStack item = this.from.getCurrentItem();
            ItemMeta meta = item.getItemMeta();
            String name = this.initialValue.get();
            meta.setDisplayName(name == null ? "Not set" : name);
            item.setItemMeta(meta);
        }

        @ClickHandler(slot={0, 2})
        public void save(InventoryMenuSlot slot, CitizensInventoryClickEvent evt) {
            evt.setCancelled(true);
            if (((Boolean)this.callback.apply((Object)slot.getCurrentItem().getItemMeta().getDisplayName())).booleanValue()) {
                this.ctx.getMenu().transitionBack();
            }
        }
    }

    @Menu(type=InventoryType.CHEST)
    private static class ChoiceInputMenu<T>
    extends InventoryMenuPage {
        private final Consumer<List<Choice<T>>> callback;
        private final Choice<T>[] choices;
        private final String title;
        private final Choice.Type type;

        public ChoiceInputMenu(String title, Choice.Type type, Consumer<List<Choice<T>>> callback, Choice<T>[] choices) {
            this.title = title;
            this.callback = callback;
            this.choices = choices;
            this.type = type;
        }

        @Override
        public Inventory createInventory(String title) {
            if (this.choices.length <= 3) {
                return Bukkit.createInventory(null, (InventoryType)InventoryType.HOPPER, (String)this.title);
            }
            return Bukkit.createInventory(null, (int)Math.min(54, this.choices.length / 5 * 9 + 9), (String)this.title);
        }

        @Override
        public void initialise(MenuContext ctx) {
            for (int i = 0; i < this.choices.length; ++i) {
                Choice<T> choice = this.choices[i];
                InventoryMenuSlot slot = ctx.getSlot(i * 2);
                slot.setItemStack(choice.createDisplayItem());
                slot.setClickHandler(evt -> {
                    evt.setCancelled(true);
                    boolean newState = !choice.isActive();
                    switch (this.type) {
                        case TOGGLE: {
                            choice.setActive(newState);
                            slot.setItemStack(choice.createDisplayItem());
                            break;
                        }
                        case PICKER: {
                            for (int j = 0; j < this.choices.length; ++j) {
                                this.choices[j].setActive(false);
                            }
                            choice.setActive(true);
                            ctx.getMenu().transitionBack();
                        }
                    }
                });
            }
        }

        @Override
        public void onClose(HumanEntity entity) {
            ArrayList ret = Lists.newArrayListWithExpectedSize((int)this.choices.length);
            for (Choice<T> choice : this.choices) {
                if (!choice.isActive()) continue;
                ret.add(choice);
            }
            this.callback.accept(ret);
        }
    }

    public static class Choice<T> {
        private boolean active;
        private String description;
        private Material material;
        private T value;

        public ItemStack createDisplayItem() {
            ItemStack item = new ItemStack(this.getDisplayMaterial(), 1);
            ItemMeta meta = item.getItemMeta();
            if (this.getDescription().contains("\n")) {
                String[] parts = this.getDescription().split("\n", 2);
                meta.setDisplayName(parts[0]);
                meta.setLore(Arrays.asList(parts[1].split("\n")));
            } else if (this.getValue() instanceof Enum) {
                String name = ((Enum)this.getValue()).name();
                meta.setDisplayName(name.charAt(0) + name.substring(1).toLowerCase());
                meta.setLore(Arrays.asList(this.getDescription().split("\n")));
            }
            meta.setDisplayName((this.isActive() ? ChatColor.GREEN : ChatColor.RED) + meta.getDisplayName());
            item.setItemMeta(meta);
            return item;
        }

        public String getDescription() {
            return Colorizer.parseColors(this.description);
        }

        public Material getDisplayMaterial() {
            return this.material;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public static <T> Choice<T> of(T value, Material display, String description, boolean active) {
            Choice<T> ret = new Choice<T>();
            ret.active = active;
            ret.material = display;
            ret.value = value;
            ret.description = description;
            return ret;
        }

        public static enum Type {
            PICKER,
            TOGGLE;

        }
    }
}

