/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.GoalController;
import net.citizensnpcs.api.ai.SimpleGoalController;
import net.citizensnpcs.api.ai.speech.SimpleSpeechController;
import net.citizensnpcs.api.ai.speech.SpeechController;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCAddTraitEvent;
import net.citizensnpcs.api.event.NPCCloneEvent;
import net.citizensnpcs.api.event.NPCRemoveByCommandSenderEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.event.NPCRemoveTraitEvent;
import net.citizensnpcs.api.event.NPCTeleportEvent;
import net.citizensnpcs.api.npc.MetadataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.npc.SimpleMetadataStore;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Speech;
import net.citizensnpcs.api.util.Colorizer;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.MemoryDataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public abstract class AbstractNPC
implements NPC {
    private final GoalController goalController = new SimpleGoalController();
    private final int id;
    private final MetadataStore metadata = new SimpleMetadataStore(){

        @Override
        public void remove(String key) {
            super.remove(key);
            if (AbstractNPC.this.getEntity() != null) {
                AbstractNPC.this.getEntity().removeMetadata(key, CitizensAPI.getPlugin());
            }
        }

        @Override
        public void set(String key, Object data) {
            super.set(key, data);
            if (AbstractNPC.this.getEntity() != null) {
                AbstractNPC.this.getEntity().setMetadata(key, (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), data));
            }
        }

        @Override
        public void setPersistent(String key, Object data) {
            super.setPersistent(key, data);
            if (AbstractNPC.this.getEntity() != null) {
                AbstractNPC.this.getEntity().setMetadata(key, (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), data));
            }
        }
    };
    private String name;
    private final NPCRegistry registry;
    private final List<String> removedTraits = Lists.newArrayList();
    private final List<Runnable> runnables = Lists.newArrayList();
    private final SpeechController speechController = new SimpleSpeechController(this);
    protected final Map<Class<? extends Trait>, Trait> traits = Maps.newHashMap();
    private final UUID uuid;

    protected AbstractNPC(UUID uuid, int id, String name, NPCRegistry registry) {
        this.uuid = uuid;
        this.id = id;
        this.registry = registry;
        this.name = name;
        CitizensAPI.getTraitFactory().addDefaultTraits(this);
    }

    @Override
    public void addRunnable(Runnable runnable) {
        this.runnables.add(runnable);
    }

    @Override
    public void addTrait(Class<? extends Trait> clazz) {
        this.addTrait(this.getTraitFor(clazz));
    }

    @Override
    public void addTrait(Trait trait) {
        if (trait == null) {
            Messaging.severe("Cannot register a null trait. Was it registered properly?");
            return;
        }
        if (trait.getNPC() == null) {
            trait.linkToNPC(this);
        }
        Class<?> clazz = trait.getClass();
        Trait replaced = this.traits.get(clazz);
        Bukkit.getPluginManager().registerEvents((Listener)trait, CitizensAPI.getPlugin());
        this.traits.put(clazz, trait);
        if (this.isSpawned()) {
            trait.onSpawn();
        }
        if (trait.isRunImplemented()) {
            if (replaced != null) {
                this.runnables.remove(replaced);
            }
            this.runnables.add(trait);
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCAddTraitEvent(this, trait));
    }

    @Override
    public NPC clone() {
        return this.copy();
    }

    @Override
    public NPC copy() {
        NPC copy = this.registry.createNPC(this.getOrAddTrait(MobType.class).getType(), this.getFullName());
        MemoryDataKey key = new MemoryDataKey();
        this.save(key);
        copy.load(key);
        for (Trait trait : copy.getTraits()) {
            trait.onCopy();
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCCloneEvent(this, copy));
        return copy;
    }

    @Override
    public MetadataStore data() {
        return this.metadata;
    }

    @Override
    public boolean despawn() {
        return this.despawn(DespawnReason.PLUGIN);
    }

    @Override
    public void destroy() {
        Bukkit.getPluginManager().callEvent((Event)new NPCRemoveEvent(this));
        this.runnables.clear();
        for (Trait trait : this.traits.values()) {
            HandlerList.unregisterAll((Listener)trait);
            trait.onRemove();
        }
        this.traits.clear();
        this.goalController.clear();
        this.registry.deregister(this);
    }

    @Override
    public void destroy(CommandSender source) {
        Bukkit.getPluginManager().callEvent((Event)new NPCRemoveByCommandSenderEvent(this, source));
        this.destroy();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractNPC other = (AbstractNPC)obj;
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    @Override
    public GoalController getDefaultGoalController() {
        return this.goalController;
    }

    @Override
    public SpeechController getDefaultSpeechController() {
        if (!this.hasTrait(Speech.class)) {
            this.addTrait(Speech.class);
        }
        return this.speechController;
    }

    protected EntityType getEntityType() {
        return this.isSpawned() ? this.getEntity().getType() : this.getOrAddTrait(MobType.class).getType();
    }

    @Override
    public String getFullName() {
        int nameLength = SpigotUtil.getMaxNameLength(this.getEntityType());
        String replaced = Placeholders.replace(Colorizer.parseColors(this.name), null, this);
        if (replaced.length() > nameLength) {
            Messaging.severe("ID", this.id, "created with name length greater than " + nameLength + ", truncating", replaced, "to", replaced.substring(0, nameLength));
            replaced = replaced.substring(0, nameLength);
        }
        return replaced;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return Colorizer.stripColors(this.name);
    }

    @Override
    public <T extends Trait> T getOrAddTrait(Class<T> clazz) {
        Trait trait = this.traits.get(clazz);
        if (trait == null) {
            trait = this.getTraitFor(clazz);
            this.addTrait(trait);
        }
        return (T)((Trait)clazz.cast(trait));
    }

    @Override
    public NPCRegistry getOwningRegistry() {
        return this.registry;
    }

    @Override
    @Deprecated
    public <T extends Trait> T getTrait(Class<T> clazz) {
        return this.getOrAddTrait(clazz);
    }

    protected Trait getTraitFor(Class<? extends Trait> clazz) {
        return CitizensAPI.getTraitFactory().getTrait(clazz);
    }

    @Override
    public <T extends Trait> T getTraitNullable(Class<T> clazz) {
        return (T)((Trait)clazz.cast(this.traits.get(clazz)));
    }

    @Override
    public Iterable<Trait> getTraits() {
        return this.traits.values();
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    public int hashCode() {
        return 31 + this.uuid.hashCode();
    }

    @Override
    public boolean hasTrait(Class<? extends Trait> trait) {
        return this.traits.containsKey(trait);
    }

    @Override
    public boolean isFlyable() {
        return this.data().get("flyable", Boolean.valueOf(false));
    }

    @Override
    public boolean isProtected() {
        return this.data().get("protected", Boolean.valueOf(true));
    }

    @Override
    public void load(final DataKey root) {
        this.name = root.getString("name");
        this.metadata.loadFrom(root.getRelative("metadata"));
        String traitNames = root.getString("traitnames");
        HashSet keys = Sets.newHashSet(root.getRelative("traits").getSubKeys());
        Iterables.addAll((Collection)keys, (Iterable)Iterables.transform((Iterable)Splitter.on((char)',').split((CharSequence)traitNames), (Function)new Function<String, DataKey>(){

            public DataKey apply(String input) {
                return root.getRelative("traits." + input);
            }
        }));
        DataKey locationKey = root.getRelative("traits.location");
        if (locationKey.keyExists()) {
            this.loadTraitFromKey(locationKey);
            keys.remove(locationKey);
        }
        for (DataKey key : keys) {
            this.loadTraitFromKey(key);
        }
    }

    private void loadTraitFromKey(DataKey traitKey) {
        Trait trait;
        Class<? extends Trait> clazz = CitizensAPI.getTraitFactory().getTraitClass(traitKey.name());
        if (this.hasTrait(clazz)) {
            trait = this.getTraitNullable(clazz);
        } else {
            trait = CitizensAPI.getTraitFactory().getTrait(clazz);
            if (trait == null) {
                Messaging.severeTr("citizens.notifications.trait-load-failed", traitKey.name(), this.getId());
                return;
            }
            this.addTrait(trait);
        }
        try {
            PersistenceLoader.load(trait, traitKey);
            trait.load(traitKey);
        }
        catch (Throwable ex) {
            if (Messaging.isDebugging()) {
                ex.printStackTrace();
            }
            Messaging.logTr("citizens.notifications.trait-load-failed", traitKey.name(), this.getId());
        }
    }

    @Override
    public void removeTrait(Class<? extends Trait> traitClass) {
        Trait trait = this.traits.remove(traitClass);
        if (trait != null) {
            Bukkit.getPluginManager().callEvent((Event)new NPCRemoveTraitEvent(this, trait));
            this.removedTraits.add(trait.getName());
            if (trait.isRunImplemented()) {
                this.runnables.remove(trait);
            }
            HandlerList.unregisterAll((Listener)trait);
            trait.onRemove();
        }
    }

    @Override
    public boolean requiresNameHologram() {
        return this.getEntityType() != EntityType.ARMOR_STAND && (this.name.length() > 16 && this.getEntityType() == EntityType.PLAYER || this.data().get("always-use-name-hologram", Boolean.valueOf(false)) != false || this.name.contains("&x") || this.name.contains("\u00a7x") || !Placeholders.replace(this.name, null, this).equals(this.name));
    }

    @Override
    public void save(DataKey root) {
        if (!this.metadata.get("should-save", Boolean.valueOf(true)).booleanValue()) {
            return;
        }
        this.metadata.saveTo(root.getRelative("metadata"));
        root.setString("name", this.name);
        root.setString("uuid", this.uuid.toString());
        StringBuilder traitNames = new StringBuilder();
        for (Trait trait : this.traits.values()) {
            DataKey traitKey = root.getRelative("traits." + trait.getName());
            trait.save(traitKey);
            try {
                PersistenceLoader.save(trait, traitKey);
            }
            catch (Throwable t) {
                Messaging.log("PersistenceLoader failed for", trait);
                t.printStackTrace();
                continue;
            }
            this.removedTraits.remove(trait.getName());
            traitNames.append(trait.getName() + ",");
        }
        if (traitNames.length() > 0) {
            root.setString("traitnames", traitNames.substring(0, traitNames.length() - 1));
        } else {
            root.setString("traitnames", "");
        }
        for (String name : this.removedTraits) {
            root.removeKey("traits." + name);
        }
        this.removedTraits.clear();
    }

    @Override
    public void setAlwaysUseNameHologram(boolean use) {
        this.data().setPersistent("always-use-name-hologram", (Object)use);
    }

    @Override
    public void setFlyable(boolean flyable) {
        this.data().setPersistent("flyable", (Object)flyable);
    }

    @Override
    public void setName(String name) {
        this.name = name;
        if (!this.isSpawned()) {
            return;
        }
        Entity bukkitEntity = this.getEntity();
        if (bukkitEntity instanceof LivingEntity) {
            ((LivingEntity)bukkitEntity).setCustomName(this.getFullName());
        }
        if (bukkitEntity.getType() == EntityType.PLAYER && !this.requiresNameHologram()) {
            Location old = bukkitEntity.getLocation();
            this.despawn(DespawnReason.PENDING_RESPAWN);
            this.spawn(old);
        }
    }

    @Override
    public void setProtected(boolean isProtected) {
        this.data().setPersistent("protected", (Object)isProtected);
    }

    @Override
    public void setUseMinecraftAI(boolean use) {
        this.data().setPersistent("minecraft-ai", (Object)use);
    }

    private void teleport(final Entity entity, final Location location, int delay) {
        final Entity passenger = entity.getPassenger();
        entity.eject();
        if (!location.getWorld().equals(entity.getWorld())) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    entity.teleport(location);
                }
            }, (long)delay++);
        } else {
            entity.teleport(location);
        }
        if (passenger == null) {
            return;
        }
        this.teleport(passenger, location, delay++);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                entity.setPassenger(passenger);
            }
        };
        if (!location.getWorld().equals(entity.getWorld())) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), task, (long)delay);
        } else {
            task.run();
        }
    }

    @Override
    public void teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (!this.isSpawned()) {
            return;
        }
        NPCTeleportEvent event = new NPCTeleportEvent(this, location);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        Entity entity = this.getEntity();
        while (entity.getVehicle() != null) {
            entity = entity.getVehicle();
        }
        location.getBlock().getChunk();
        this.teleport(entity, location, 5);
    }

    protected void unloadEvents() {
        this.runnables.clear();
        for (Trait trait : this.traits.values()) {
            HandlerList.unregisterAll((Listener)trait);
        }
        this.traits.clear();
        this.goalController.clear();
    }

    public void update() {
        for (int i = 0; i < this.runnables.size(); ++i) {
            this.runnables.get(i).run();
        }
        if (this.isSpawned()) {
            this.goalController.run();
        }
    }

    @Override
    public boolean useMinecraftAI() {
        return this.data().get("minecraft-ai", Boolean.valueOf(false));
    }
}

