/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.citizensnpcs.api.astar.Agent;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Path
implements Plan {
    private List<Block> blockList;
    private int index = 0;
    private final PathEntry[] path;
    private static Material YELLOW_FLOWER = SpigotUtil.isUsing1_13API() ? Material.SUNFLOWER : Material.valueOf((String)"YELLOW_FLOWER");

    public Path(Collection<Vector> vector) {
        this.path = (PathEntry[])Iterables.toArray((Iterable)Iterables.transform(vector, (Function)new Function<Vector, PathEntry>(){

            public PathEntry apply(Vector input) {
                return new PathEntry(input, Collections.emptyList());
            }
        }), PathEntry.class);
    }

    Path(Iterable<VectorNode> unfiltered) {
        this.path = this.cull(unfiltered);
    }

    private PathEntry[] cull(Iterable<VectorNode> unfiltered) {
        ArrayList path = Lists.newArrayList();
        for (VectorNode node : unfiltered) {
            for (Vector vector : node.getPathVectors()) {
                path.add(new PathEntry(vector, node.callbacks));
            }
        }
        return path.toArray(new PathEntry[path.size()]);
    }

    public void debug() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            for (PathEntry entry : this.path) {
                if (SpigotUtil.isUsing1_13API()) {
                    player.sendBlockChange(entry.vector.toLocation(player.getWorld()), YELLOW_FLOWER.createBlockData());
                    continue;
                }
                player.sendBlockChange(entry.vector.toLocation(player.getWorld()), YELLOW_FLOWER, (byte)0);
            }
        }
    }

    public void debugEnd() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            for (PathEntry entry : this.path) {
                Block block = entry.vector.toLocation(player.getWorld()).getBlock();
                if (SpigotUtil.isUsing1_13API()) {
                    player.sendBlockChange(block.getLocation(), block.getBlockData());
                    continue;
                }
                player.sendBlockChange(block.getLocation(), block.getType(), block.getData());
            }
        }
    }

    public Vector getCurrentVector() {
        return this.path[this.index].vector;
    }

    public Iterable<Vector> getPath() {
        return Iterables.transform(Arrays.asList(this.path), (Function)new Function<PathEntry, Vector>(){

            public Vector apply(PathEntry input) {
                return input.vector;
            }
        });
    }

    @Override
    public boolean isComplete() {
        return this.index >= this.path.length;
    }

    public void run(NPC npc) {
        this.path[this.index].run(npc);
    }

    public String toString() {
        return Arrays.toString(this.path);
    }

    @Override
    public void update(Agent agent) {
        if (this.isComplete()) {
            return;
        }
        this.path[this.index].onComplete((NPC)agent);
        ++this.index;
    }

    private class PathEntry {
        final List<PathPoint.PathCallback> callbacks;
        final Vector vector;

        private PathEntry(Vector vector, List<PathPoint.PathCallback> callbacks) {
            this.vector = vector;
            this.callbacks = callbacks;
        }

        public void onComplete(NPC npc) {
            if (this.callbacks == null) {
                return;
            }
            Block current = npc.getEntity().getWorld().getBlockAt(this.vector.getBlockX(), this.vector.getBlockY(), this.vector.getBlockZ());
            for (PathPoint.PathCallback callback : this.callbacks) {
                callback.onReached(npc, current);
            }
        }

        public void run(final NPC npc) {
            if (this.callbacks == null) {
                return;
            }
            Block current = npc.getEntity().getWorld().getBlockAt(this.vector.getBlockX(), this.vector.getBlockY(), this.vector.getBlockZ());
            for (PathPoint.PathCallback callback : this.callbacks) {
                if (Path.this.blockList == null) {
                    Path.this.blockList = Lists.transform(Arrays.asList(Path.this.path), (Function)new Function<PathEntry, Block>(){

                        public Block apply(PathEntry input) {
                            return npc.getEntity().getWorld().getBlockAt(input.vector.getBlockX(), input.vector.getBlockY(), input.vector.getBlockZ());
                        }
                    });
                }
                callback.run(npc, current, Path.this.blockList, Path.this.index);
            }
        }

        public String toString() {
            return this.vector.toString();
        }
    }
}

