/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.FileStorage;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlStorageWithLists
implements FileStorage {
    private final FileConfiguration config = new YamlConfiguration();
    private final File file;
    private static Field LOADER_OPTIONS;
    private static Method SET_CODEPOINT_LIMIT;

    public YamlStorageWithLists(File file) {
        this(file, null);
    }

    public YamlStorageWithLists(File file, String header) {
        this.tryIncreaseMaxCodepoints(this.config);
        this.file = file;
        if (!file.exists()) {
            this.create();
            if (header != null) {
                this.config.options().header(header);
            }
            this.save();
        }
    }

    private void create() {
        try {
            Bukkit.getLogger().log(Level.INFO, "Creating file: " + this.file.getName());
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not create file: " + this.file.getName());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        YamlStorageWithLists other = (YamlStorageWithLists)obj;
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public YamlKey getKey(String root) {
        return new YamlKey(root);
    }

    public int hashCode() {
        return 31 + (this.file == null ? 0 : this.file.hashCode());
    }

    @Override
    public boolean load() {
        try {
            this.config.load(this.file);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private boolean pathExists(String key) {
        return this.config.get(key) != null;
    }

    @Override
    public void save() {
        try {
            Files.createParentDirs((File)this.file);
            File temporaryFile = File.createTempFile(this.file.getName(), null, this.file.getParentFile());
            temporaryFile.deleteOnExit();
            this.config.save(temporaryFile);
            this.file.delete();
            temporaryFile.renameTo(this.file);
            temporaryFile.delete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String toString() {
        return "YamlStorage {file=" + this.file + "}";
    }

    private void tryIncreaseMaxCodepoints(FileConfiguration config) {
        if (SET_CODEPOINT_LIMIT == null || LOADER_OPTIONS == null) {
            return;
        }
        try {
            SET_CODEPOINT_LIMIT.invoke(LOADER_OPTIONS.get(config), 0x4000000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            LOADER_OPTIONS = YamlConfiguration.class.getDeclaredField("yamlLoaderOptions");
            LOADER_OPTIONS.setAccessible(true);
            SET_CODEPOINT_LIMIT = Class.forName("org.yaml.snakeyaml.LoaderOptions").getMethod("setCodepointLimit", Integer.TYPE);
            SET_CODEPOINT_LIMIT.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class YamlKey
    extends DataKey {
        public YamlKey(String root) {
            super(root);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj) || this.getClass() != obj.getClass()) {
                return false;
            }
            YamlKey other = (YamlKey)obj;
            return this.getOuterType().equals(other.getOuterType());
        }

        private Object get(String path, Object def) {
            int i2;
            int i1 = -1;
            Function<String, Object> next = k -> {
                ConfigurationSection res = YamlStorageWithLists.this.config.getConfigurationSection(k);
                return res == null ? YamlStorageWithLists.this.config.getList(k) : res;
            };
            Object relative = YamlStorageWithLists.this.config;
            while ((i1 = path.indexOf(46, i2 = i1 + 1)) != -1) {
                String curr = path.substring(i2, i1);
                relative = next.apply(curr);
                if (relative == null) {
                    return def;
                }
                if (relative instanceof List) {
                    List list = (List)relative;
                    next = k -> {
                        if (Ints.tryParse((String)k) >= list.size()) {
                            return def;
                        }
                        return list.get(Ints.tryParse((String)k));
                    };
                    continue;
                }
                if (relative instanceof ConfigurationSection) {
                    ConfigurationSection section = (ConfigurationSection)relative;
                    next = k -> {
                        ConfigurationSection res = section.getConfigurationSection(k);
                        return res == null ? section.getList(k) : res;
                    };
                    continue;
                }
                if (!(relative instanceof Map)) continue;
                Map map = (Map)relative;
                next = k -> map.get(k);
            }
            if (relative == null) {
                return def;
            }
            if (relative instanceof ConfigurationSection) {
                return ((ConfigurationSection)relative).get(path.substring(i2));
            }
            if (relative instanceof List) {
                return ((List)relative).get(Ints.tryParse((String)path.substring(i2)));
            }
            if (relative instanceof Map) {
                return ((Map)relative).get(path.substring(i2));
            }
            throw new RuntimeException();
        }

        @Override
        public boolean getBoolean(String key) {
            String path = this.createRelativeKey(key);
            Object val = this.get(path, null);
            if (val != null) {
                return Boolean.parseBoolean(val.toString());
            }
            return false;
        }

        @Override
        public boolean getBoolean(String key, boolean def) {
            return (Boolean)this.get(this.createRelativeKey(key), def);
        }

        @Override
        public double getDouble(String key) {
            return this.getDouble(key, 0.0);
        }

        @Override
        public double getDouble(String key, double def) {
            String path = this.createRelativeKey(key);
            Object val = this.get(path, def);
            if (val != null) {
                if (val instanceof Number) {
                    return ((Number)val).doubleValue();
                }
                String str = val.toString();
                return str.isEmpty() ? def : Double.parseDouble(str);
            }
            return def;
        }

        @Override
        public DataKey getFromRoot(String path) {
            return new YamlKey(path);
        }

        @Override
        public int getInt(String key) {
            return this.getInt(key, 0);
        }

        @Override
        public int getInt(String key, int def) {
            String path = this.createRelativeKey(key);
            Object val = this.get(path, def);
            if (val != null) {
                if (val instanceof Number) {
                    return ((Number)val).intValue();
                }
                String str = val.toString();
                return str.isEmpty() ? def : Integer.parseInt(str);
            }
            return def;
        }

        @Override
        public long getLong(String key) {
            return this.getLong(key, 0L);
        }

        @Override
        public long getLong(String key, long def) {
            String path = this.createRelativeKey(key);
            Object val = this.get(path, def);
            if (val != null) {
                if (val instanceof Number) {
                    return ((Number)val).longValue();
                }
                String str = val.toString();
                return str.isEmpty() ? def : Long.parseLong(str);
            }
            return def;
        }

        private YamlStorageWithLists getOuterType() {
            return YamlStorageWithLists.this;
        }

        @Override
        public Object getRaw(String key) {
            return this.get(this.createRelativeKey(key), null);
        }

        @Override
        public YamlKey getRelative(String relative) {
            if (relative == null || relative.isEmpty()) {
                return this;
            }
            return new YamlKey(this.createRelativeKey(relative));
        }

        public YamlStorageWithLists getStorage() {
            return YamlStorageWithLists.this;
        }

        @Override
        public String getString(String key) {
            String path = this.createRelativeKey(key);
            Object val = this.get(path, null);
            if (val != null) {
                return val.toString();
            }
            return "";
        }

        @Override
        public Iterable<DataKey> getSubKeys() {
            Object value = this.get(this.path, null);
            if (value == null) {
                return Collections.emptyList();
            }
            if (value instanceof List) {
                return IntStream.range(0, ((List)value).size()).mapToObj(i -> this.getRelative(i)).collect(Collectors.toList());
            }
            if (value instanceof Map) {
                return ((Map)value).keySet().stream().map(k -> this.getRelative((String)k)).collect(Collectors.toList());
            }
            ConfigurationSection section = (ConfigurationSection)value;
            return section.getKeys(false).stream().map(k -> this.getRelative((String)k)).collect(Collectors.toList());
        }

        @Override
        public Map<String, Object> getValuesDeep() {
            return this.sectionToValues(YamlStorageWithLists.this.config.getConfigurationSection(this.path));
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 31 * super.hashCode() + this.getOuterType().hashCode();
            return result;
        }

        @Override
        public boolean keyExists(String key) {
            return this.get(this.createRelativeKey(key), null) != null;
        }

        @Override
        public String name() {
            int last = this.path.lastIndexOf(46);
            return this.path.substring(last == 0 ? 0 : last + 1);
        }

        @Override
        public void removeKey(String key) {
            YamlStorageWithLists.this.config.set(this.createRelativeKey(key), null);
        }

        private void set(String path, Object value) {
            int i2;
            int i1 = -1;
            Object prev = YamlStorageWithLists.this.config;
            while ((i1 = path.indexOf(46, i2 = i1 + 1)) != -1) {
                Integer idx;
                String curr = path.substring(i2, i1);
                Cloneable next = null;
                if (prev instanceof ConfigurationSection) {
                    next = ((ConfigurationSection)prev).get(curr);
                } else if (prev instanceof Map) {
                    next = ((Map)prev).get(curr);
                } else if (prev instanceof List && (idx = Ints.tryParse((String)curr)) != null) {
                    List list = (List)prev;
                    while (list.size() <= idx) {
                        list.add(new HashMap());
                    }
                    next = list.get(idx);
                }
                int nextSegment = path.indexOf(46, i1 + 1);
                if (nextSegment != -1 && Ints.tryParse((String)path.substring(i1 + 1, nextSegment)) != null) {
                    if (!(next instanceof List)) {
                        next = new ArrayList();
                        if (prev instanceof ConfigurationSection) {
                            ((ConfigurationSection)prev).set(curr, next);
                        } else if (prev instanceof Map) {
                            ((Map)prev).put(curr, next);
                        }
                    }
                } else if (next == null) {
                    if (prev instanceof ConfigurationSection) {
                        next = ((ConfigurationSection)prev).createSection(curr);
                    } else if (prev instanceof Map) {
                        next = new HashMap();
                        ((Map)prev).put(curr, next);
                    }
                }
                prev = next;
            }
            if (prev == null) {
                throw new RuntimeException();
            }
            if (prev instanceof ConfigurationSection) {
                ((ConfigurationSection)prev).set(path.substring(i2), value);
            } else if (prev instanceof List) {
                ((List)prev).set(Ints.tryParse((String)path.substring(i2)), value);
            } else if (prev instanceof Map) {
                ((Map)prev).put(path.substring(i2), value);
            }
        }

        @Override
        public void setBoolean(String key, boolean value) {
            this.set(this.createRelativeKey(key), value);
        }

        @Override
        public void setDouble(String key, double value) {
            this.set(this.createRelativeKey(key), String.valueOf(value));
        }

        @Override
        public void setInt(String key, int value) {
            this.set(this.createRelativeKey(key), value);
        }

        @Override
        public void setLong(String key, long value) {
            this.set(this.createRelativeKey(key), value);
        }

        @Override
        public void setRaw(String key, Object value) {
            this.set(this.createRelativeKey(key), value);
        }

        @Override
        public void setString(String key, String value) {
            this.set(this.createRelativeKey(key), value);
        }

        public String toString() {
            return "YamlKey [path=" + this.path + "]";
        }
    }
}

