/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.gui;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.citizensnpcs.api.gui.CitizensInventoryClickEvent;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.gui.MenuSlot;
import net.citizensnpcs.api.util.Messaging;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryMenuSlot {
    private Set<InventoryAction> actionFilter;
    private final List<Consumer<CitizensInventoryClickEvent>> handlers = Lists.newArrayList();
    private final int index;
    private final Inventory inventory;

    InventoryMenuSlot(MenuContext menu, int index) {
        this.inventory = menu.getInventory();
        this.index = index;
    }

    public void addClickHandler(Consumer<CitizensInventoryClickEvent> func) {
        this.handlers.add(func);
    }

    public void clear() {
        this.handlers.clear();
        this.actionFilter = null;
        this.setItemStack(null);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InventoryMenuSlot other = (InventoryMenuSlot)obj;
        if (this.index != other.index) {
            return false;
        }
        return !(this.inventory == null ? other.inventory != null : !this.inventory.equals(other.inventory));
    }

    public ItemStack getCurrentItem() {
        return this.inventory.getItem(this.index);
    }

    public Collection<InventoryAction> getFilter() {
        return this.actionFilter;
    }

    public int hashCode() {
        int result = 31 + this.index;
        return 31 * result + (this.inventory == null ? 0 : this.inventory.hashCode());
    }

    void initialise(MenuSlot data) {
        ItemMeta meta;
        ItemStack defaultItem = null;
        if (data.compatMaterial().length > 1) {
            String str;
            Material mat = null;
            String[] stringArray = data.compatMaterial();
            int n = stringArray.length;
            for (int i = 0; i < n && (mat = Material.getMaterial((String)(str = stringArray[i]))) == null; ++i) {
            }
            defaultItem = new ItemStack(mat, data.amount());
        } else if (data.material() != null) {
            defaultItem = new ItemStack(data.material(), data.amount());
        }
        if (defaultItem != null && (meta = defaultItem.getItemMeta()) != null) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            if (!data.lore().equals("EMPTY")) {
                meta.setLore(Arrays.asList(Messaging.parseComponents(Messaging.tryTranslate(data.lore())).split("\\n|\n|<br>")));
            }
            if (!data.title().equals("EMPTY")) {
                meta.setDisplayName(Messaging.parseComponents(Messaging.tryTranslate(data.title())));
            }
            defaultItem.setItemMeta(meta);
        }
        this.inventory.setItem(this.index, defaultItem);
    }

    void onClick(CitizensInventoryClickEvent event) {
        if (this.actionFilter == null && this.handlers.isEmpty() || this.actionFilter != null && !this.actionFilter.contains(event.getAction())) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
        }
        for (Consumer runnable : Lists.newArrayList(this.handlers)) {
            runnable.accept(event);
        }
    }

    public void setClickHandler(Consumer<CitizensInventoryClickEvent> handler) {
        this.handlers.clear();
        this.handlers.add(handler);
    }

    public void setDescription(String description) {
        ItemStack item = this.inventory.getItem(this.index);
        ItemMeta meta = item.getItemMeta();
        List<String> list = Arrays.asList(Messaging.parseComponents(description).split("\\n|\n|<br>"));
        meta.setDisplayName(ChatColor.RESET + list.get(0));
        meta.setLore(list.subList(1, list.size()));
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        this.inventory.setItem(this.index, item);
    }

    public void setFilter(Collection<InventoryAction> filter) {
        this.actionFilter = filter == null || filter.isEmpty() ? EnumSet.allOf(InventoryAction.class) : EnumSet.copyOf(filter);
    }

    public void setItemStack(ItemStack stack) {
        this.inventory.setItem(this.index, stack);
    }

    public void setItemStack(ItemStack stack, String name) {
        this.setItemStack(stack, name, null);
    }

    public void setItemStack(ItemStack stack, String name, String description) {
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName(ChatColor.RESET + Messaging.parseComponents(name));
        if (description != null) {
            meta.setLore(Arrays.asList(Messaging.parseComponents(description).split("\n")));
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        stack.setItemMeta(meta);
        this.inventory.setItem(this.index, stack);
    }
}

