/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api;

import ch.ethz.globis.phtree.PhTreeF;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.scheduler.BukkitRunnable;

public class LocationLookup
extends BukkitRunnable {
    private final Map<String, PerPlayerMetadata<?>> metadata = Maps.newHashMap();
    private final Map<UUID, PhTreeF<Player>> worlds = Maps.newHashMap();

    public PerPlayerMetadata<?> getMetadata(String key) {
        return this.metadata.get(key);
    }

    public Iterable<Player> getNearbyPlayers(Location base, double dist) {
        PhTreeF<Player> tree = this.worlds.get(base.getWorld().getUID());
        if (tree == null) {
            return Collections.emptyList();
        }
        return () -> tree.rangeQuery(dist, new double[]{base.getX(), base.getY(), base.getZ()});
    }

    public void onJoin(PlayerJoinEvent event) {
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
            this.updateWorld(event.getPlayer().getWorld());
            for (PerPlayerMetadata<?> meta : this.metadata.values()) {
                if (((PerPlayerMetadata)meta).onJoin == null) continue;
                ((PerPlayerMetadata)meta).onJoin.accept(meta, event);
            }
        });
    }

    public void onQuit(PlayerQuitEvent event) {
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
            this.updateWorld(event.getPlayer().getWorld());
            for (PerPlayerMetadata<?> meta : this.metadata.values()) {
                ((PerPlayerMetadata)meta).sent.remove(event.getPlayer().getUniqueId());
            }
        });
    }

    public <T> PerPlayerMetadata<T> registerMetadata(String key, BiConsumer<PerPlayerMetadata<T>, PlayerJoinEvent> onJoin) {
        return this.metadata.computeIfAbsent(key, s -> new PerPlayerMetadata(onJoin));
    }

    public void run() {
        Bukkit.getServer().getWorlds().forEach(this::updateWorld);
    }

    private void updateWorld(World world) {
        List players = world.getPlayers();
        if (players.isEmpty()) {
            this.worlds.remove(world.getUID());
            return;
        }
        PhTreeF tree = this.worlds.computeIfAbsent(world.getUID(), uid -> PhTreeF.create((int)3));
        tree.clear();
        Location loc = new Location(null, 0.0, 0.0, 0.0);
        for (Player player : players) {
            if (player.hasMetadata("NPC")) continue;
            player.getLocation(loc);
            tree.put(new double[]{loc.getX(), loc.getY(), loc.getZ()}, (Object)player);
        }
    }

    public static class PerPlayerMetadata<T> {
        private final BiConsumer<PerPlayerMetadata<T>, PlayerJoinEvent> onJoin;
        private final Map<UUID, Map<String, T>> sent = Maps.newHashMap();

        public PerPlayerMetadata(BiConsumer<PerPlayerMetadata<T>, PlayerJoinEvent> onJoin) {
            this.onJoin = onJoin;
        }

        public T getMarker(UUID key, String value) {
            return (T)this.sent.getOrDefault(key, Collections.emptyMap()).get(value);
        }

        public boolean has(UUID key, String value) {
            return this.sent.getOrDefault(key, Collections.emptyMap()).containsKey(value);
        }

        public boolean remove(UUID key, String value) {
            return this.sent.getOrDefault(key, Collections.emptyMap()).remove(value) != null;
        }

        public void set(UUID key, String value, T marker) {
            this.sent.computeIfAbsent(key, k -> Maps.newHashMap()).put(value, marker);
        }
    }
}

