/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.ItemStorage;
import org.bukkit.Bukkit;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

@TraitName(value="inventory")
public class Inventory
extends Trait {
    private ItemStack[] contents;
    private InventoryCloseListener listener;
    private org.bukkit.inventory.Inventory view;
    private final Set<InventoryView> views = new HashSet<InventoryView>();
    private static boolean SUPPORT_ABSTRACT_HORSE = true;

    public Inventory() {
        super("inventory");
        this.contents = new ItemStack[72];
    }

    public ItemStack[] getContents() {
        if (this.view != null && !this.views.isEmpty()) {
            return this.view.getContents();
        }
        if (this.npc.isSpawned()) {
            this.saveContents(this.npc.getEntity());
        }
        return this.contents;
    }

    public org.bukkit.inventory.Inventory getInventoryView() {
        return this.view;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.contents = this.parseContents(key);
    }

    @Override
    public void onDespawn() {
        if (this.npc.getEntity() instanceof InventoryHolder) {
            this.contents = ((InventoryHolder)this.npc.getEntity()).getInventory().getContents();
        }
    }

    @Override
    public void onSpawn() {
        this.setContents(this.contents);
        int size = this.npc.getEntity() instanceof Player ? 36 : (this.npc.getEntity() instanceof InventoryHolder ? ((InventoryHolder)this.npc.getEntity()).getInventory().getSize() : this.contents.length);
        int rem = size % 9;
        if (rem != 0) {
            size += 9 - rem;
        }
        if (size > 54) {
            size = 54;
        }
        if (size < 9) {
            size = 9;
        }
        String name = this.npc.getName().length() >= 19 ? this.npc.getName().substring(0, 19) + "~" : this.npc.getName();
        this.view = Bukkit.createInventory((InventoryHolder)(this.npc.getEntity() instanceof InventoryHolder ? (InventoryHolder)this.npc.getEntity() : null), (int)size, (String)(name + "'s Inventory"));
        for (int i = 0; i < this.view.getSize(); ++i) {
            this.view.setItem(i, this.contents[i]);
        }
    }

    public void openInventory(Player sender) {
        if (this.listener != null) {
            this.listener = new InventoryCloseListener();
            Bukkit.getPluginManager().registerEvents((Listener)this.listener, CitizensAPI.getPlugin());
        }
        for (int i = 0; i < this.view.getSize() && i < this.contents.length; ++i) {
            this.view.setItem(i, this.contents[i]);
        }
        this.views.add(sender.openInventory(this.view));
    }

    private ItemStack[] parseContents(DataKey key) throws NPCLoadException {
        ItemStack[] contents = new ItemStack[72];
        for (DataKey slotKey : key.getIntegerSubKeys()) {
            contents[Integer.parseInt((String)slotKey.name())] = ItemStorage.loadItemStack(slotKey);
        }
        return contents;
    }

    @Override
    public void run() {
        if (this.views.isEmpty()) {
            return;
        }
        Iterator<InventoryView> itr = this.views.iterator();
        while (itr.hasNext()) {
            InventoryView iview = itr.next();
            if (iview.getPlayer().isValid()) continue;
            iview.close();
            itr.remove();
        }
    }

    @Override
    public void save(DataKey key) {
        if (this.npc.isSpawned()) {
            this.saveContents(this.npc.getEntity());
        }
        int slot = 0;
        for (ItemStack item : this.contents) {
            key.removeKey(String.valueOf(slot));
            if (item != null) {
                ItemStorage.saveItem(key.getRelative(String.valueOf(slot)), item);
            }
            ++slot;
        }
    }

    private void saveContents(Entity entity) {
        if (this.view != null && !this.views.isEmpty()) {
            this.contents = this.view.getContents();
        } else if (entity instanceof InventoryHolder) {
            this.contents = ((InventoryHolder)entity).getInventory().getContents();
        }
    }

    public void setContents(ItemStack[] contents) {
        int i;
        int maxCopySize;
        PlayerInventory dest;
        block14: {
            this.contents = Arrays.copyOf(contents, 72);
            dest = null;
            maxCopySize = -1;
            if (this.npc.getEntity() instanceof Player) {
                dest = ((Player)this.npc.getEntity()).getInventory();
                maxCopySize = 36;
            } else if (this.npc.getEntity() instanceof StorageMinecart) {
                dest = ((StorageMinecart)this.npc.getEntity()).getInventory();
            }
            if (SUPPORT_ABSTRACT_HORSE) {
                try {
                    if (this.npc.getEntity() instanceof AbstractHorse) {
                        dest = ((AbstractHorse)this.npc.getEntity()).getInventory();
                    }
                    break block14;
                }
                catch (Throwable t) {
                    SUPPORT_ABSTRACT_HORSE = false;
                    if (this.npc.getEntity() instanceof Horse) {
                        dest = ((Horse)this.npc.getEntity()).getInventory();
                    }
                    break block14;
                }
            }
            if (this.npc.getEntity() instanceof Horse) {
                dest = ((Horse)this.npc.getEntity()).getInventory();
            }
        }
        if (dest == null) {
            return;
        }
        if (maxCopySize == -1) {
            maxCopySize = dest.getSize();
        }
        for (i = 0; i < maxCopySize; ++i) {
            if (i >= contents.length) continue;
            dest.setItem(i, contents[i]);
        }
        if (this.view == null) {
            return;
        }
        for (i = 0; i < maxCopySize; ++i) {
            if (i >= contents.length || i >= this.view.getSize()) continue;
            this.view.setItem(i, contents[i]);
        }
    }

    public void setItem(int slot, ItemStack item) {
        if (item != null) {
            item = item.clone();
        }
        if (this.view != null && this.view.getSize() > slot) {
            this.view.setItem(slot, item);
        } else if (this.contents.length > slot) {
            this.contents[slot] = item;
        } else {
            throw new IndexOutOfBoundsException();
        }
        if (this.npc.getEntity() instanceof InventoryHolder) {
            ((InventoryHolder)this.npc.getEntity()).getInventory().setItem(slot, item);
        }
        if (slot == 0 && this.npc.getEntity() instanceof LivingEntity) {
            this.npc.getOrAddTrait(Equipment.class).setItemInHand(item);
        }
    }

    void setItemInHand(ItemStack item) {
        if (item != null) {
            item = item.clone();
        }
        if (this.view != null && this.view.getSize() > 0) {
            this.view.setItem(0, item);
        } else if (this.contents.length > 0) {
            this.contents[0] = item;
        }
    }

    public String toString() {
        return "Inventory{" + Arrays.toString(this.contents) + "}";
    }

    private class InventoryCloseListener
    implements Listener {
        private InventoryCloseListener() {
        }

        @EventHandler(ignoreCancelled=true)
        public void inventoryCloseEvent(InventoryCloseEvent event) {
            if (!Inventory.this.views.contains(event.getView())) {
                return;
            }
            ItemStack[] contents = event.getInventory().getContents();
            for (int i = 0; i < contents.length; ++i) {
                ((Inventory)Inventory.this).contents[i] = contents[i];
                if (i != 0 || !(Inventory.this.npc.getEntity() instanceof LivingEntity)) continue;
                Inventory.this.npc.getOrAddTrait(Equipment.class).setItemInHand(contents[i]);
            }
            if (Inventory.this.npc.getEntity() instanceof InventoryHolder) {
                try {
                    int maxSize = ((InventoryHolder)Inventory.this.npc.getEntity()).getInventory().getStorageContents().length;
                    ((InventoryHolder)Inventory.this.npc.getEntity()).getInventory().setStorageContents(Arrays.copyOf(contents, maxSize));
                }
                catch (NoSuchMethodError e) {
                    int maxSize = ((InventoryHolder)Inventory.this.npc.getEntity()).getInventory().getContents().length;
                    ((InventoryHolder)Inventory.this.npc.getEntity()).getInventory().setContents(Arrays.copyOf(contents, maxSize));
                }
            }
            Inventory.this.views.remove(event.getView());
        }
    }
}

