/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.collect.Maps;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import net.citizensnpcs.api.util.Messaging;

public class Translator {
    private final Locale defaultLocale;
    private final Map<String, MessageFormat> messageFormatCache = Maps.newHashMap();
    private ResourceBundle preferredBundle;
    private final File resourceFile;
    private static ResourceBundle defaultBundle;
    private static Translator instance;
    private static final Pattern JAPANESE_PATTERN;
    private static final String PREFIX = "messages";

    private Translator(File resourceFile, Locale locale) {
        this.resourceFile = resourceFile;
        this.defaultLocale = locale;
        try {
            this.preferredBundle = ResourceBundle.getBundle(PREFIX, this.defaultLocale, new FileClassLoader(Translator.class.getClassLoader(), resourceFile));
        }
        catch (MissingResourceException e) {
            this.preferredBundle = this.getDefaultBundle();
            Messaging.log("No translation for system language (" + this.defaultLocale + "): defaulting to English");
        }
    }

    private String format(String key, Locale locale, Object ... msg) {
        String unreplaced = this.translate(key, locale);
        MessageFormat formatter = this.getFormatter(unreplaced);
        return formatter.format(msg);
    }

    private ResourceBundle getBundle(Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(PREFIX, locale, new FileClassLoader(Translator.class.getClassLoader(), this.resourceFile));
            return bundle == null ? this.preferredBundle : bundle;
        }
        catch (MissingResourceException e) {
            return this.preferredBundle;
        }
    }

    private ResourceBundle getDefaultBundle() {
        return Translator.getDefaultResourceBundle(this.resourceFile, "messages_en.properties");
    }

    private MessageFormat getFormatter(String unreplaced) {
        MessageFormat formatter = this.messageFormatCache.get(unreplaced);
        if (formatter == null) {
            formatter = new MessageFormat(unreplaced);
            this.messageFormatCache.put(unreplaced, formatter);
        }
        return formatter;
    }

    private String translate(String key, Locale locale) {
        ResourceBundle bundle = this.preferredBundle;
        if (locale != this.defaultLocale) {
            bundle = this.getBundle(locale);
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            try {
                return this.getDefaultBundle().getString(key);
            }
            catch (MissingResourceException ex) {
                return "?" + key + "?";
            }
        }
    }

    public static String format(String msg, Object ... objects) {
        MessageFormat formatter = instance.getFormatter(msg);
        return formatter.format(objects);
    }

    private static Charset getCharset(String fileName) {
        Charset charset = JAPANESE_PATTERN.matcher(fileName).find() && Charset.isSupported("Shift-JIS") ? Charset.forName("Shift-JIS") : StandardCharsets.UTF_8;
        return charset;
    }

    private static Properties getDefaultBundleProperties() {
        Properties defaults = new Properties();
        try (InputStreamReader in = new InputStreamReader(Translator.class.getResourceAsStream("/messages_en.properties"), StandardCharsets.UTF_8);){
            defaults.load(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return defaults;
    }

    private static ResourceBundle getDefaultResourceBundle(File resourceDirectory, String fileName) {
        if (defaultBundle != null) {
            return defaultBundle;
        }
        resourceDirectory.mkdirs();
        File bundleFile = new File(resourceDirectory, fileName);
        if (!bundleFile.exists()) {
            try {
                bundleFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Translator.populateDefaults(bundleFile);
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(bundleFile), Translator.getCharset(fileName));){
            defaultBundle = new PropertyResourceBundle(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
            defaultBundle = Translator.getFallbackResourceBundle();
        }
        return defaultBundle;
    }

    private static ResourceBundle getFallbackResourceBundle() {
        return new ListResourceBundle(){

            @Override
            protected Object[][] getContents() {
                return new Object[0][0];
            }
        };
    }

    private static void populateDefaults(File bundleFile) {
        Properties properties = new Properties();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(bundleFile), Translator.getCharset(bundleFile.getName()));){
            properties.load(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Properties defaults = Translator.getDefaultBundleProperties();
        for (Map.Entry<Object, Object> entry : defaults.entrySet()) {
            if (properties.containsKey(entry.getKey())) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        try (OutputStreamWriter stream = new OutputStreamWriter((OutputStream)new FileOutputStream(bundleFile), Translator.getCharset(bundleFile.getName()));){
            properties.store(stream, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setInstance(File dataFolder, Locale preferredLocale) {
        instance = new Translator(dataFolder, preferredLocale);
    }

    public static String translate(String key, Locale preferredLocale, Object ... msg) {
        return msg.length == 0 ? instance.translate(key, preferredLocale) : instance.format(key, preferredLocale, msg);
    }

    public static String translate(String key, Object ... msg) {
        return Translator.translate(key, Translator.instance.defaultLocale, msg);
    }

    static {
        JAPANESE_PATTERN = Pattern.compile(".*?_ja(_jp)?\\.properties", 2);
    }

    private static class FileClassLoader
    extends ClassLoader {
        private final File folder;

        public FileClassLoader(ClassLoader classLoader, File folder) {
            super(classLoader);
            this.folder = folder;
        }

        @Override
        public URL getResource(String string) {
            File file = new File(this.folder, string);
            if (file.exists()) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                }
            } else {
                string = string.replaceFirst("/", "");
                URL test = Translator.class.getResource('/' + string);
                if (test != null) {
                    return test;
                }
            }
            return super.getResource(string);
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            File file = new File(this.folder, string);
            if (file.exists()) {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            } else {
                string = string.replaceFirst("/", "");
                InputStream stream = Translator.class.getResourceAsStream('/' + string);
                if (stream != null) {
                    new Thread(new SaveResource(this.folder, string)).start();
                    return stream;
                }
            }
            return super.getResourceAsStream(string);
        }
    }

    public static interface TranslationProvider {
        public InputStream createInputStream();

        public String getName();
    }

    private static class SaveResource
    implements Runnable {
        private final String fileName;
        private final File rootFolder;

        private SaveResource(File rootFolder, String fileName) {
            this.rootFolder = rootFolder;
            this.fileName = fileName;
        }

        @Override
        public void run() {
            File file = new File(this.rootFolder, this.fileName);
            if (file.exists()) {
                return;
            }
            try {
                this.rootFolder.mkdirs();
                File to = File.createTempFile(this.fileName, null, this.rootFolder);
                to.deleteOnExit();
                Resources.asByteSource((URL)Resources.getResource(Translator.class, (String)('/' + this.fileName))).copyTo(Files.asByteSink((File)to, (FileWriteMode[])new FileWriteMode[0]));
                if (!file.exists()) {
                    to.renameTo(file);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

