/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

public class BoundingBox {
    public final double maxX;
    public final double maxY;
    public final double maxZ;
    public final double minX;
    public final double minY;
    public final double minZ;
    public static final BoundingBox EMPTY = new BoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public BoundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public BoundingBox add(int x, int y, int z) {
        return new BoundingBox(this.minX + (double)x, this.minY + (double)y, this.minZ + (double)z, this.maxX + (double)x, this.maxY + (double)y, this.maxZ + (double)z);
    }

    public BoundingBox clone() {
        return new BoundingBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingBox other = (BoundingBox)obj;
        if (Double.doubleToLongBits(this.maxX) != Double.doubleToLongBits(other.maxX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxY) != Double.doubleToLongBits(other.maxY)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxZ) != Double.doubleToLongBits(other.maxZ)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minX) != Double.doubleToLongBits(other.minX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minY) != Double.doubleToLongBits(other.minY)) {
            return false;
        }
        return Double.doubleToLongBits(this.minZ) == Double.doubleToLongBits(other.minZ);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.maxX);
        result = 31 + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxZ);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minZ);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public BoundingBox mul(double scale) {
        return new BoundingBox(this.minX * scale, this.minY * scale, this.minZ * scale, this.maxX * scale, this.maxY * scale, this.maxZ * scale);
    }

    public BoundingBox mul(double x, double y, double z) {
        return new BoundingBox(this.minX * x, this.minY * y, this.minZ * z, this.maxX * x, this.maxY * y, this.maxZ * z);
    }

    public String toString() {
        return "BoundingBox [" + this.minX + ", " + this.minY + ", " + this.minZ + ", " + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }

    public static BoundingBox convert(org.bukkit.util.BoundingBox bukkit) {
        return new BoundingBox(bukkit.getMinX(), bukkit.getMinY(), bukkit.getMinZ(), bukkit.getMaxX(), bukkit.getMaxY(), bukkit.getMaxZ());
    }
}

