/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import java.util.UUID;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;

@TraitName(value="owner")
public class Owner
extends Trait {
    private UUID uuid = null;

    public Owner() {
        super("owner");
    }

    @Deprecated
    public String getOwner() {
        return this.uuid == null ? "SERVER" : this.uuid.toString();
    }

    public UUID getOwnerId() {
        return this.uuid;
    }

    public boolean isOwnedBy(CommandSender sender) {
        if (sender == null) {
            return false;
        }
        if (this.uuid == null && sender instanceof ConsoleCommandSender) {
            return true;
        }
        if (sender instanceof OfflinePlayer && this.uuid != null && this.uuid.equals(((OfflinePlayer)sender).getUniqueId())) {
            return true;
        }
        return sender.hasPermission("citizens.admin") || this.uuid == null && sender.hasPermission("citizens.admin");
    }

    public boolean isOwnedBy(String name) {
        return this.uuid == null ? "SERVER".equals(name) : this.uuid != null && this.uuid.toString().equalsIgnoreCase(name);
    }

    public boolean isOwnedBy(UUID other) {
        return this.uuid == null ? other == null : this.uuid.equals(other);
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.uuid = key.keyExists("uuid") && !key.getString("uuid").isEmpty() ? UUID.fromString(key.getString("uuid")) : null;
        key.removeKey("owner");
    }

    @Override
    public void save(DataKey key) {
        key.setString("uuid", this.uuid == null ? "" : this.uuid.toString());
    }

    public void setOwner(CommandSender sender) {
        this.uuid = sender instanceof OfflinePlayer ? ((OfflinePlayer)sender).getUniqueId() : null;
    }

    @Deprecated
    public void setOwner(String owner) {
        this.setOwner(owner, null);
    }

    @Deprecated
    public void setOwner(String owner, UUID uuid) {
        this.uuid = uuid;
    }

    public void setOwner(UUID uuid) {
        this.uuid = uuid;
    }

    public String toString() {
        return "Owner{" + this.uuid + "}";
    }
}

