/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.CitizensDisableEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class Placeholders
implements Listener {
    private static final Pattern PLACEHOLDER_MATCHER = Pattern.compile("<(id|npc|owner|random_player|random_world_player|random_npc|random_npc_id|nearest_npc_id|nearest_player|world)>");
    private static boolean PLACEHOLDERAPI_ENABLED = true;
    private static final List<PlaceholderProvider> PLACEHOLDERS = Lists.newArrayList();
    private static final Pattern PLAYER_PLACEHOLDER_MATCHER = Pattern.compile("(<player>|<p>|@p|%player%|<random_player>|<random_world_player>|<random_npc>|<random_npc_id>|<nearest_npc_id>|<nearest_player>|<world>)");
    private static final String[] PLAYER_PLACEHOLDERS = new String[]{"<player>", "<p>", "@p", "%player%"};
    private static final Collection<String> PLAYER_VARIABLES = ImmutableSet.of((Object)"<player>", (Object)"<p>", (Object)"@p", (Object)"%player%");

    private static OfflinePlayer getPlayer(BlockCommandSender sender) {
        return CitizensAPI.getNMSHelper().getPlayer(sender);
    }

    private static String getWorldReplacement(Location location, String group, Entity excluding) {
        if (group.charAt(0) != '<') {
            group = '<' + group + '>';
        }
        switch (group) {
            case "<random_player>": 
            case "<random_world_player>": {
                Collection players = group.equals("<random_player>") ? Bukkit.getServer().getOnlinePlayers() : location.getWorld().getPlayers();
                Player possible = (Player)Iterables.get((Iterable)players, (int)new Random().nextInt(players.size()), null);
                if (possible == null) break;
                return possible.getName();
            }
            case "<random_npc>": 
            case "<random_npc_id>": {
                ArrayList all = Lists.newArrayList((Iterable)CitizensAPI.getNPCRegistry());
                if (all.size() <= 0) break;
                NPC random = (NPC)all.get(new Random().nextInt(all.size()));
                return group.equals("<random_npc>") ? random.getName() : Integer.toString(random.getId());
            }
            case "<nearest_npc_id>": {
                Optional<NPC> closestNPC = location.getWorld().getNearbyEntities(location, 25.0, 25.0, 25.0).stream().map(CitizensAPI.getNPCRegistry()::getNPC).filter(e -> e != null && e.getEntity() != excluding).min((a, b) -> Double.compare(a.getEntity().getLocation().distanceSquared(location), b.getEntity().getLocation().distanceSquared(location)));
                if (!closestNPC.isPresent()) break;
                return Integer.toString(closestNPC.get().getId());
            }
            case "<nearest_player>": {
                double min = Double.MAX_VALUE;
                Player closest = null;
                for (Player entity : CitizensAPI.getLocationLookup().getNearbyPlayers(location, 25.0)) {
                    double dist;
                    if (entity == excluding || CitizensAPI.getNPCRegistry().isNPC((Entity)entity) || (dist = entity.getLocation().distanceSquared(location)) > min) continue;
                    min = dist;
                    closest = entity;
                }
                if (closest == null) break;
                return closest.getName();
            }
            case "<world>": {
                return location.getWorld().getName();
            }
        }
        return "";
    }

    @EventHandler
    private static void onCitizensDisable(CitizensDisableEvent event) {
        PLACEHOLDERS.clear();
    }

    public static void registerNPCPlaceholder(Pattern regex, PlaceholderFunction func) {
        if (regex.pattern().charAt(0) != '<') {
            regex = Pattern.compile('<' + regex.pattern() + '>', regex.flags());
        }
        PLACEHOLDERS.add(new PlaceholderProvider(regex, func));
    }

    public static String replace(String text, CommandSender sender, NPC npc) {
        text = Placeholders.replace(text, (OfflinePlayer)(sender instanceof OfflinePlayer ? (OfflinePlayer)sender : (sender instanceof BlockCommandSender ? Placeholders.getPlayer((BlockCommandSender)sender) : null)));
        if (npc == null || text == null) {
            return text;
        }
        StringBuffer out = new StringBuffer();
        Matcher matcher = PLACEHOLDER_MATCHER.matcher(text);
        while (matcher.find()) {
            String group;
            String replacement = "";
            switch (group = matcher.group(1)) {
                case "id": {
                    replacement = Integer.toString(npc.getId());
                    break;
                }
                case "npc": {
                    replacement = npc.getName();
                    break;
                }
                case "owner": {
                    replacement = npc.getOrAddTrait(Owner.class).getOwner();
                    break;
                }
                default: {
                    replacement = Placeholders.getWorldReplacement(npc.getStoredLocation(), group, npc.getEntity());
                }
            }
            matcher.appendReplacement(out, "");
            out.append(replacement);
        }
        matcher.appendTail(out);
        for (PlaceholderProvider entry : PLACEHOLDERS) {
            matcher = entry.regex.matcher(out.toString());
            out = new StringBuffer();
            while (matcher.find()) {
                String group = matcher.group().substring(1, matcher.group().length() - 1);
                matcher.appendReplacement(out, "");
                out.append(entry.func.apply(npc, sender, group));
            }
            matcher.appendTail(out);
        }
        return out.toString();
    }

    public static String replace(String text, OfflinePlayer player) {
        if (player == null || !player.isOnline() && !player.hasPlayedBefore()) {
            return Placeholders.setPlaceholderAPIPlaceholders(text, player);
        }
        if (text == null) {
            return text;
        }
        if (player.getPlayer() != null) {
            StringBuffer out = new StringBuffer();
            Matcher matcher = PLAYER_PLACEHOLDER_MATCHER.matcher(text);
            while (matcher.find()) {
                String replacement = "";
                String group = matcher.group(1);
                replacement = PLAYER_VARIABLES.contains(group) ? player.getName() : Placeholders.getWorldReplacement(player.getPlayer().getLocation(), group, (Entity)player.getPlayer());
                matcher.appendReplacement(out, "");
                out.append(replacement);
            }
            matcher.appendTail(out);
            text = out.toString();
        } else {
            for (int i = 0; i < PLAYER_PLACEHOLDERS.length; ++i) {
                text = text.replace(PLAYER_PLACEHOLDERS[i], player.getName());
            }
        }
        return Placeholders.setPlaceholderAPIPlaceholders(text, player);
    }

    private static String setPlaceholderAPIPlaceholders(String text, OfflinePlayer player) {
        if (!PLACEHOLDERAPI_ENABLED) {
            return text;
        }
        try {
            return PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)text);
        }
        catch (Throwable t) {
            PLACEHOLDERAPI_ENABLED = false;
            return text;
        }
    }

    private static class PlaceholderProvider {
        PlaceholderFunction func;
        Pattern regex;

        PlaceholderProvider(Pattern regex, PlaceholderFunction func) {
            this.regex = regex;
            this.func = func;
        }
    }

    public static interface PlaceholderFunction {
        public String apply(NPC var1, CommandSender var2, String var3);
    }
}

