/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.command;

import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.Arg;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandAnnotationProcessor;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Injector;
import net.citizensnpcs.api.command.RequirementsProcessor;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.command.exception.NoPermissionsException;
import net.citizensnpcs.api.command.exception.ServerCommandException;
import net.citizensnpcs.api.command.exception.UnhandledCommandException;
import net.citizensnpcs.api.command.exception.WrappedCommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Paginator;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandManager
implements TabCompleter {
    private final Map<Class<? extends Annotation>, CommandAnnotationProcessor> annotationProcessors = Maps.newHashMap();
    private final Map<String, CommandInfo> commands = Maps.newHashMap();
    private TimeUnit defaultDurationUnits;
    private Injector injector;
    private Function<Command, String> translationPrefixProvider;
    private static final String COMMAND_FORMAT = "<green>/{{%s%s <green>- [[%s";
    private static final Logger logger = Logger.getLogger(CommandManager.class.getCanonicalName());

    public CommandManager() {
        this.registerAnnotationProcessor(new RequirementsProcessor());
    }

    public void execute(org.bukkit.command.Command command, String[] args, CommandSender sender, Object ... methodArgs) throws CommandException {
        String[] newArgs = new String[args.length + 1];
        System.arraycopy(args, 0, newArgs, 1, args.length);
        newArgs[0] = command.getName().toLowerCase();
        Object[] newMethodArgs = new Object[methodArgs.length + 1];
        System.arraycopy(methodArgs, 0, newMethodArgs, 1, methodArgs.length);
        this.executeCommand(newArgs, sender, newMethodArgs);
    }

    private void executeCommand(String[] args, CommandSender sender, Object[] methodArgs) throws CommandException {
        String cmdName = args[0].toLowerCase();
        String modifier = args.length > 1 ? args[1] : "";
        boolean help = modifier.toLowerCase().equals("help");
        CommandInfo info = this.getCommand(cmdName, modifier);
        if (info == null || info.method == null) {
            if (help) {
                this.executeHelp(args, sender);
                return;
            }
            info = this.commands.get(cmdName + " *");
        }
        if (info == null && args.length > 2) {
            info = this.getCommand(cmdName, args[1], args[2]);
        }
        if (info == null) {
            throw new UnhandledCommandException();
        }
        if (!info.serverCommand && sender instanceof ConsoleCommandSender) {
            throw new ServerCommandException();
        }
        if (!this.hasPermission(info, sender)) {
            throw new NoPermissionsException();
        }
        Command cmd = info.commandAnnotation;
        if (cmd.parsePlaceholders()) {
            NPC npc = methodArgs.length > 2 && methodArgs[2] instanceof NPC ? (NPC)methodArgs[2] : null;
            for (int i = 1; i < args.length; ++i) {
                args[i] = Placeholders.replace(args[i], sender, npc);
            }
        }
        CommandContext context = new CommandContext(sender, args);
        if (cmd.requiresFlags() && !context.hasAnyFlags()) {
            throw new CommandUsageException("", this.getUsage(args, cmd));
        }
        if (context.argsLength() < cmd.min()) {
            throw new CommandUsageException("citizens.commands.requirements.too-few-arguments", this.getUsage(args, cmd));
        }
        if (cmd.max() != -1 && context.argsLength() > cmd.max()) {
            throw new CommandUsageException("citizens.commands.requirements.too-many-arguments", this.getUsage(args, cmd));
        }
        if (!cmd.flags().contains("*")) {
            for (char c : context.getFlags()) {
                if (cmd.flags().indexOf(String.valueOf(c)) != -1) continue;
                throw new CommandUsageException("Unknown flag: " + c, this.getUsage(args, cmd));
            }
        }
        methodArgs[0] = context;
        for (Annotation annotation : info.annotations) {
            CommandAnnotationProcessor processor = this.annotationProcessors.get(annotation.annotationType());
            processor.process(sender, context, annotation, methodArgs);
        }
        if (info.methodArguments.size() > 0) {
            methodArgs = Arrays.copyOf(methodArgs, methodArgs.length + info.methodArguments.size());
            for (Map.Entry entry : info.methodArguments.entrySet()) {
                Class desiredType = ((InjectedCommandArgument)entry.getValue()).paramType;
                Object val = ((InjectedCommandArgument)entry.getValue()).getInput(context);
                if (val != null) {
                    if (((InjectedCommandArgument)entry.getValue()).validator != null) {
                        val = ((InjectedCommandArgument)entry.getValue()).validator.validate(context, sender, methodArgs.length > 2 && methodArgs[2] instanceof NPC ? (NPC)methodArgs[2] : null, val.toString());
                    } else if (desiredType == Material.class) {
                        val = SpigotUtil.isUsing1_13API() ? Material.matchMaterial((String)val.toString(), (boolean)false) : Material.matchMaterial((String)val.toString());
                    } else if (Enum.class.isAssignableFrom(desiredType)) {
                        val = CommandManager.matchEnum((Enum[])((Enum[])desiredType.getEnumConstants()), (String)val.toString().toUpperCase());
                    } else if (desiredType == Double.TYPE || desiredType == Double.class) {
                        val = Double.parseDouble(val.toString());
                    } else if (desiredType == Integer.TYPE || desiredType == Integer.class) {
                        val = Integer.parseInt(val.toString());
                    } else if (desiredType == Boolean.TYPE || desiredType == Boolean.class) {
                        val = Boolean.parseBoolean(val.toString());
                    } else if (desiredType == Float.TYPE || desiredType == Float.class) {
                        val = Float.valueOf(Float.parseFloat(val.toString()));
                    } else if (desiredType == Location.class) {
                        val = CommandContext.parseLocation(context.getSenderLocation(), val.toString());
                    } else if (desiredType == ItemStack.class) {
                        val = CommandContext.parseItemStack(val.toString());
                    } else if (desiredType == UUID.class) {
                        val = UUID.fromString(val.toString());
                    } else if (desiredType == Duration.class) {
                        val = SpigotUtil.parseDuration(val.toString(), this.defaultDurationUnits);
                    }
                }
                methodArgs[((Integer)entry.getKey()).intValue()] = val;
            }
        }
        try {
            info.method.invoke(info.instance, methodArgs);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE, "Failed to execute command", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "Failed to execute command", e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CommandException) {
                if (e.getCause() instanceof CommandUsageException && ((CommandUsageException)e.getCause()).getUsage() == null) {
                    ((CommandUsageException)e.getCause()).setUsage(this.getUsage(args, cmd));
                }
                throw (CommandException)e.getCause();
            }
            throw new WrappedCommandException(e.getCause());
        }
    }

    private void executeHelp(String[] args, CommandSender sender) throws CommandException {
        if (!sender.hasPermission("citizens." + args[0] + ".help")) {
            throw new NoPermissionsException();
        }
        int page = 1;
        try {
            page = args.length == 3 ? Integer.parseInt(args[2]) : page;
        }
        catch (NumberFormatException e) {
            this.sendSpecificHelp(sender, args[0], args[2]);
            return;
        }
        this.sendHelp(sender, args[0], page);
    }

    public boolean executeSafe(org.bukkit.command.Command command, String[] args, CommandSender sender, Object ... methodArgs) {
        block11: {
            try {
                try {
                    this.execute(command, args, sender, methodArgs);
                }
                catch (ServerCommandException ex) {
                    Messaging.sendTr(sender, "citizens.commands.requirements.must-be-ingame", new Object[0]);
                }
                catch (CommandUsageException ex) {
                    if (ex.getMessage() != null && !ex.getMessage().isEmpty()) {
                        Messaging.sendError(sender, ex.getMessage());
                    }
                    Messaging.sendError(sender, ex.getUsage());
                }
                catch (UnhandledCommandException ex) {
                    Messaging.sendErrorTr(sender, "citizens.commands.unknown-command", new Object[0]);
                    return false;
                }
                catch (WrappedCommandException ex) {
                    if (ex.getCause() instanceof NumberFormatException) {
                        if (Messaging.isDebugging()) {
                            ex.printStackTrace();
                        }
                        Messaging.sendErrorTr(sender, "citizens.commands.invalid-number", new Object[0]);
                        break block11;
                    }
                    throw ex.getCause();
                }
                catch (CommandException ex) {
                    Messaging.sendError(sender, ex.getMessage());
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (!(sender instanceof Player)) break block11;
                Messaging.sendErrorTr(sender, "citizens.commands.console-error", new Object[0]);
                Messaging.sendError(sender, ex.getClass().getName() + ": " + ex.getMessage());
            }
        }
        return true;
    }

    private String format(Command command, String alias) {
        String description = command.desc();
        if (this.translationPrefixProvider != null && description.isEmpty()) {
            description = this.translationPrefixProvider.apply(command) + ".description";
        }
        return String.format(COMMAND_FORMAT, alias, command.usage().isEmpty() ? "" : " " + command.usage(), Messaging.tryTranslate(description));
    }

    public String getClosestCommandModifier(String command, String modifier) {
        int minDist = Integer.MAX_VALUE;
        command = command.toLowerCase();
        String closest = "";
        for (String cmd : this.commands.keySet()) {
            int distance;
            String[] split = cmd.split(" ");
            if (split.length <= 1 || !split[0].equals(command) || minDist <= (distance = CommandManager.getLevenshteinDistance(modifier, split[1]))) continue;
            minDist = distance;
            closest = split[1];
        }
        return closest;
    }

    public CommandInfo getCommand(String ... commandParts) {
        return this.commands.get(Joiner.on((char)' ').join((Object[])commandParts).toLowerCase());
    }

    public List<CommandInfo> getCommands(String topLevelCommand) {
        topLevelCommand = topLevelCommand.toLowerCase();
        ArrayList cmds = Lists.newArrayList();
        for (Map.Entry<String, CommandInfo> entry : this.commands.entrySet()) {
            if (!entry.getKey().startsWith(topLevelCommand) || entry.getValue() == null) continue;
            cmds.add(entry.getValue());
        }
        return cmds;
    }

    private List<String> getLines(CommandSender sender, String baseCommand) {
        HashSet processed = Sets.newHashSet();
        ArrayList<String> lines = new ArrayList<String>();
        for (CommandInfo info : this.getCommands(baseCommand)) {
            Command command = info.getCommandAnnotation();
            if (processed.contains(info) || !sender.hasPermission("citizens.admin") && !sender.hasPermission(command.permission())) continue;
            lines.add(this.format(command, baseCommand));
            if (command.modifiers().length <= 0) continue;
            processed.add(info);
        }
        Collections.sort(lines);
        return lines;
    }

    private String getUsage(String[] args, Command cmd) {
        return "/" + (args[0] + " ") + cmd.usage();
    }

    public boolean hasCommand(org.bukkit.command.Command cmd, String ... modifier) {
        String cmdName = cmd.getName().toLowerCase();
        String[] parts = new String[modifier.length + 1];
        System.arraycopy(modifier, 0, parts, 1, modifier.length);
        parts[0] = cmdName;
        return this.hasCommand(parts);
    }

    public boolean hasCommand(String ... parts) {
        if (parts == null || parts.length == 0) {
            throw new IllegalArgumentException("parts must not be empty");
        }
        return this.commands.containsKey(Joiner.on((char)' ').join((Object[])parts)) || this.commands.containsKey(parts[0] + " *");
    }

    private boolean hasPermission(CommandInfo method, CommandSender sender) {
        Command cmd = method.commandAnnotation;
        return cmd.permission().isEmpty() || sender.hasPermission(cmd.permission()) || sender.hasPermission("citizens.admin");
    }

    public List<String> onTabComplete(CommandSender sender, org.bukkit.command.Command command, String alias, String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length <= 2 && args[0].equalsIgnoreCase("help")) {
            return this.getCommands(command.getName().toLowerCase()).stream().map(info -> ((CommandInfo)info).commandAnnotation.modifiers().length > 0 ? ((CommandInfo)info).commandAnnotation.modifiers()[0] : null).collect(Collectors.toList());
        }
        if (args.length <= 1) {
            String search = args.length == 1 ? args[0] : "";
            for (String base : this.commands.keySet()) {
                String modifier;
                String[] parts = base.split(" ");
                String cmd = parts[0];
                if (!cmd.equalsIgnoreCase(command.getName()) || parts.length < 2 || !(modifier = parts[1]).startsWith(search)) continue;
                results.add(modifier);
            }
            return results;
        }
        CommandInfo cmd = this.getCommand(command.getName().toLowerCase(), args[0]);
        if (cmd == null && args.length > 1) {
            cmd = this.getCommand(command.getName().toLowerCase(), args[0], args[1]);
        }
        if (cmd == null) {
            return results;
        }
        String[] newArgs = new String[args.length + 1];
        System.arraycopy(args, 0, newArgs, 1, args.length);
        newArgs[0] = command.getName().toLowerCase();
        CommandContext context = new CommandContext(false, sender, newArgs);
        results.addAll(cmd.getArgTabCompletions(context, sender, args.length - 1));
        String lastArg = (newArgs.length >= 2 ? newArgs[newArgs.length - 2] : newArgs[newArgs.length - 1]).toLowerCase();
        String hyphenStrippedArg = lastArg.replaceFirst("--", "");
        if (lastArg.startsWith("--") && cmd.valueFlags().contains(hyphenStrippedArg)) {
            results.addAll(cmd.getFlagTabCompletions(context, sender, hyphenStrippedArg));
        } else {
            lastArg = newArgs[newArgs.length - 1];
            hyphenStrippedArg = lastArg.replaceFirst("--", "");
            boolean isEmpty = lastArg.isEmpty() || ImmutableSet.of((Object)"-", (Object)"--").contains((Object)lastArg);
            for (String valueFlag : cmd.valueFlags()) {
                if ((!lastArg.startsWith("--") || !valueFlag.startsWith(hyphenStrippedArg)) && (!isEmpty || context.hasValueFlag(valueFlag))) continue;
                results.add("--" + valueFlag);
            }
            String flags = cmd.commandAnnotation.flags();
            for (int i = 0; i < flags.length(); ++i) {
                char c = flags.charAt(i);
                if (!lastArg.isEmpty() || context.hasFlag(c)) continue;
                results.add("-" + c);
            }
        }
        return results;
    }

    public void register(Class<?> clazz) {
        this.registerMethods(clazz, null);
    }

    public void registerAnnotationProcessor(CommandAnnotationProcessor processor) {
        this.annotationProcessors.put(processor.getAnnotationClass(), processor);
    }

    private void registerMethods(Class<?> clazz, Method parent) {
        Object obj = this.injector != null ? this.injector.getInstance(clazz) : null;
        this.registerMethods(clazz, parent, obj);
    }

    private void registerMethods(Class<?> clazz, Method parent, Object obj) {
        for (Method method : clazz.getMethods()) {
            Class<?>[] parameterTypes;
            Class<? extends Annotation> annotationClass;
            if (!method.isAnnotationPresent(Command.class) || !Modifier.isStatic(method.getModifiers()) && obj == null) continue;
            Command cmd = method.getAnnotation(Command.class);
            CommandInfo info = new CommandInfo(cmd, method);
            info.instance = obj;
            ArrayList annotations = Lists.newArrayList();
            for (Annotation annotation : method.getDeclaringClass().getAnnotations()) {
                annotationClass = annotation.annotationType();
                if (!this.annotationProcessors.containsKey(annotationClass)) continue;
                annotations.add(annotation);
            }
            for (Annotation annotation : method.getAnnotations()) {
                annotationClass = annotation.annotationType();
                if (!this.annotationProcessors.containsKey(annotationClass)) continue;
                Iterator itr = annotations.iterator();
                while (itr.hasNext()) {
                    Annotation previous = (Annotation)itr.next();
                    if (previous.annotationType() != annotationClass) continue;
                    itr.remove();
                }
                annotations.add(annotation);
            }
            if (annotations.size() > 0) {
                info.annotations = annotations;
            }
            if ((parameterTypes = method.getParameterTypes()).length <= 1 || parameterTypes[1] == CommandSender.class) {
                info.serverCommand = true;
            }
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                for (Annotation ann : parameters[i].getAnnotations()) {
                    if (ann instanceof Flag) {
                        info.addFlagAnnotation(i, parameterTypes[i], (Flag)ann);
                        continue;
                    }
                    if (!(ann instanceof Arg)) continue;
                    info.addArgAnnotation(i, parameterTypes[i], (Arg)ann);
                }
            }
            for (String alias : cmd.aliases()) {
                for (String modifier : cmd.modifiers()) {
                    this.commands.put(alias + " " + modifier, info);
                }
                if (this.commands.containsKey(alias + " help")) continue;
                this.commands.put(alias + " help", null);
            }
        }
    }

    public void registerTabCompletion(JavaPlugin plugin) {
        for (String string : this.commands.keySet()) {
            PluginCommand command = plugin.getCommand(string.split(" ")[0]);
            if (command == null) continue;
            command.setTabCompleter((TabCompleter)this);
        }
    }

    private void sendHelp(CommandSender sender, String name, int page) throws CommandException {
        if (name.equalsIgnoreCase("npc")) {
            name = "NPC";
        }
        Paginator paginator = new Paginator().header(CommandManager.capitalize(name) + " " + Messaging.tr("citizens.commands.help.header", new Object[0])).console(sender instanceof ConsoleCommandSender);
        for (String line : this.getLines(sender, name.toLowerCase())) {
            paginator.addLine(line);
        }
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("citizens.commands.page-missing", page);
        }
    }

    private void sendSpecificHelp(CommandSender sender, String rootCommand, String modifier) throws CommandException {
        String attemptedTranslation;
        String helpKey;
        CommandInfo info = this.getCommand(rootCommand, modifier);
        if (info == null) {
            throw new CommandException("citizens.commands.help.command-missing", rootCommand + " " + modifier);
        }
        Messaging.send(sender, this.format(info.getCommandAnnotation(), rootCommand));
        String help = Messaging.tryTranslate(info.getCommandAnnotation().help());
        if (this.translationPrefixProvider != null && !(helpKey = this.translationPrefixProvider.apply(info.getCommandAnnotation()) + ".help").equals(attemptedTranslation = Messaging.tryTranslate(helpKey)) && !attemptedTranslation.isEmpty()) {
            help = attemptedTranslation;
        }
        if (help.isEmpty()) {
            return;
        }
        Messaging.send(sender, "<aqua>" + help);
    }

    public void setDefaultDurationUnits(TimeUnit unit) {
        this.defaultDurationUnits = unit;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public void setTranslationPrefixProvider(Function<Command, String> provider) {
        this.translationPrefixProvider = provider;
    }

    private static String capitalize(Object string) {
        String capitalize = string.toString();
        return capitalize.length() == 0 ? "" : Character.toUpperCase(capitalize.charAt(0)) + capitalize.substring(1);
    }

    private static int getLevenshteinDistance(String s, String t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    private static <T extends Enum<?>> T matchEnum(T[] values, String toMatch) {
        toMatch = toMatch.toLowerCase().replace('-', '_').replace(' ', '_');
        for (T check : values) {
            if (!toMatch.equals(((Enum)check).name().toLowerCase()) && (!toMatch.equals("item") || !((Enum)check).name().equals("DROPPED_ITEM"))) continue;
            return check;
        }
        for (T check : values) {
            String name = ((Enum)check).name().toLowerCase();
            if (!name.replace("_", "").equals(toMatch) && !name.startsWith(toMatch)) continue;
            return check;
        }
        return null;
    }

    public class CommandInfo {
        private List<Annotation> annotations = Lists.newArrayList();
        private final Command commandAnnotation;
        public Object instance;
        private final Method method;
        private final Map<Integer, InjectedCommandArgument> methodArguments = Maps.newHashMap();
        public boolean serverCommand;
        private Collection<String> valueFlags;

        public CommandInfo(Command commandAnnotation, Method method) {
            this.commandAnnotation = commandAnnotation;
            this.method = method;
        }

        public void addArgAnnotation(int idx, Class<?> paramType, Arg arg) {
            this.methodArguments.put(idx, new InjectedCommandArgument(CommandManager.this.injector, paramType, arg));
        }

        public void addFlagAnnotation(int idx, Class<?> paramType, Flag flag) {
            this.methodArguments.put(idx, new InjectedCommandArgument(CommandManager.this.injector, paramType, flag));
        }

        private Collection<String> calculateValueFlags() {
            this.valueFlags = new HashSet<String>();
            for (InjectedCommandArgument instance : this.methodArguments.values()) {
                instance.getValueFlag().ifPresent(flag -> this.valueFlags.add((String)flag));
            }
            this.valueFlags.addAll(Arrays.asList(this.commandAnnotation.valueFlags()));
            return this.valueFlags;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CommandInfo other = (CommandInfo)obj;
            return Objects.equals(this.commandAnnotation, other.commandAnnotation);
        }

        public Collection<? extends String> getArgTabCompletions(CommandContext args, CommandSender sender, int index) {
            ArrayList completions = Lists.newArrayList();
            for (InjectedCommandArgument instance : this.methodArguments.values()) {
                if (!instance.matches(index)) continue;
                String needle = index < args.argsLength() ? args.getString(index) : "";
                completions.addAll(Collections2.filter((Collection)instance.getTabCompletions(args, sender), s -> needle.isEmpty() || s.toLowerCase().startsWith(needle.toLowerCase())));
            }
            return completions;
        }

        public Command getCommandAnnotation() {
            return this.commandAnnotation;
        }

        public Collection<String> getFlagTabCompletions(CommandContext args, CommandSender sender, String flag) {
            ArrayList completions = Lists.newArrayList();
            for (InjectedCommandArgument instance : this.methodArguments.values()) {
                if (!instance.matches(flag)) continue;
                String needle = args.getFlag(flag, "");
                completions.addAll(Collections2.filter((Collection)instance.getTabCompletions(args, sender), s -> needle.isEmpty() || s.toLowerCase().startsWith(needle.toLowerCase())));
            }
            return completions;
        }

        public int hashCode() {
            return 31 + (this.commandAnnotation == null ? 0 : this.commandAnnotation.hashCode());
        }

        public Collection<String> valueFlags() {
            return this.valueFlags == null ? this.calculateValueFlags() : this.valueFlags;
        }
    }

    private static class InjectedCommandArgument {
        private final String[] completions;
        private Arg.CompletionsProvider completionsProvider;
        private final String defaultValue;
        private int index = -1;
        private final String[] names;
        private final Class<?> paramType;
        private String permission;
        private Arg.FlagValidator<?> validator;

        public InjectedCommandArgument(Injector injector, Class<?> paramType, Arg arg) {
            this.paramType = paramType;
            this.names = new String[0];
            this.index = arg.value();
            this.completions = arg.completions();
            String string = this.defaultValue = arg.defValue().isEmpty() ? null : arg.defValue();
            if (arg.validator() != Arg.FlagValidator.Identity.class) {
                this.validator = (Arg.FlagValidator)injector.getInstance(arg.validator());
            }
            if (arg.completionsProvider() != Arg.CompletionsProvider.Identity.class) {
                this.completionsProvider = (Arg.CompletionsProvider)injector.getInstance(arg.completionsProvider());
            }
        }

        public InjectedCommandArgument(Injector injector, Class<?> paramType, Flag flag) {
            this.paramType = paramType;
            this.names = flag.value();
            for (int i = 0; i < this.names.length; ++i) {
                this.names[i] = this.names[i].toLowerCase();
            }
            this.permission = flag.permission().isEmpty() ? null : flag.permission();
            this.completions = flag.completions();
            String string = this.defaultValue = flag.defValue().isEmpty() ? null : flag.defValue();
            if (flag.validator() != Arg.FlagValidator.Identity.class) {
                this.validator = (Arg.FlagValidator)injector.getInstance(flag.validator());
            }
            if (flag.completionsProvider() != Arg.CompletionsProvider.Identity.class) {
                this.completionsProvider = (Arg.CompletionsProvider)injector.getInstance(flag.completionsProvider());
            }
        }

        public Object getInput(CommandContext context) {
            if (this.names.length > 0) {
                String flag = this.names[0];
                String val = context.getFlag(flag, this.defaultValue);
                if (val == null && this.names.length > 1 && !this.names[1].isEmpty()) {
                    val = context.getFlag(this.names[1], this.defaultValue);
                }
                return val;
            }
            return context.getString(this.index, this.defaultValue);
        }

        private Collection<String> getTabCompletions(CommandContext args, CommandSender sender) {
            if (this.permission != null && !sender.hasPermission(this.permission)) {
                return Collections.emptyList();
            }
            if (this.completionsProvider != null) {
                return this.completionsProvider.getCompletions(args, sender, CitizensAPI.getDefaultNPCSelector().getSelected(sender));
            }
            if (this.completions.length > 0) {
                return Arrays.asList(this.completions);
            }
            if (Enum.class.isAssignableFrom(this.paramType)) {
                Enum[] constants = (Enum[])this.paramType.getEnumConstants();
                return Lists.transform(Arrays.asList(constants), Enum::name);
            }
            if (this.paramType == Boolean.TYPE || this.paramType == Boolean.class) {
                return Arrays.asList("true", "false");
            }
            return Collections.emptyList();
        }

        public Optional<String> getValueFlag() {
            return this.names.length == 0 ? Optional.empty() : Optional.of(this.names[0]);
        }

        public boolean matches(int index) {
            return this.index == index;
        }

        public boolean matches(String flag) {
            return this.names.length > 0 && (this.names[0].equalsIgnoreCase(flag) || this.names.length > 1 && this.names[1].equalsIgnoreCase(flag));
        }
    }
}

