/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class MemoryDataKey
extends DataKey {
    private String name;
    private final ConfigurationSection root;

    public MemoryDataKey() {
        super("");
        this.root = new MemoryConfiguration();
    }

    private MemoryDataKey(ConfigurationSection root, String path) {
        super(path);
        this.root = root;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryDataKey other = (MemoryDataKey)obj;
        return Objects.equals(this.path, other.path);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.root.getBoolean(this.getKeyFor(key), false);
    }

    @Override
    public double getDouble(String key) {
        return this.root.getDouble(this.getKeyFor(key), 0.0);
    }

    @Override
    public DataKey getFromRoot(String path) {
        return new MemoryDataKey(this.root, path);
    }

    @Override
    public int getInt(String key) {
        return this.root.getInt(this.getKeyFor(key), 0);
    }

    private String getKeyFor(String key) {
        if (key.isEmpty()) {
            return this.path;
        }
        if (key.charAt(0) == '.') {
            return this.path.isEmpty() ? key.substring(1) : this.path + key;
        }
        return this.path.isEmpty() ? key : this.path + "." + key;
    }

    @Override
    public long getLong(String key) {
        return this.root.getLong(this.getKeyFor(key), 0L);
    }

    @Override
    public Object getRaw(String key) {
        return this.root.get(this.getKeyFor(key));
    }

    @Override
    public MemoryDataKey getRelative(String relative) {
        String key = this.getKeyFor(relative);
        return new MemoryDataKey(this.root, key);
    }

    @Override
    public String getString(String key) {
        return this.root.getString(this.getKeyFor(key), "");
    }

    @Override
    public Iterable<DataKey> getSubKeys() {
        ConfigurationSection head = this.root.getConfigurationSection(this.path);
        if (head == null) {
            return Collections.emptyList();
        }
        Set keys = head.getKeys(false);
        return Iterables.transform((Iterable)keys, input -> new MemoryDataKey(this.root, this.getKeyFor((String)input)));
    }

    @Override
    public Map<String, Object> getValuesDeep() {
        return this.sectionToValues(this.root);
    }

    @Override
    public int hashCode() {
        return 31 + (this.path == null ? 0 : this.path.hashCode());
    }

    @Override
    public boolean keyExists(String key) {
        return this.root.isSet(this.getKeyFor(key));
    }

    @Override
    public String name() {
        if (this.name == null) {
            int idx = this.path.lastIndexOf(46);
            this.name = idx == -1 ? this.path : this.path.substring(idx + 1);
        }
        return this.name;
    }

    @Override
    public void removeKey(String key) {
        this.set(key, null);
    }

    private void set(String key, Object value) {
        this.root.set(this.getKeyFor(key), value);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.set(key, value);
    }

    @Override
    public void setDouble(String key, double value) {
        this.set(key, value);
    }

    @Override
    public void setInt(String key, int value) {
        this.set(key, value);
    }

    @Override
    public void setLong(String key, long value) {
        this.set(key, value);
    }

    @Override
    public void setRaw(String key, Object value) {
        this.set(key, value);
    }

    @Override
    public void setString(String key, String value) {
        this.set(key, value);
    }

    public String toString() {
        return "MemoryDataKey[" + this.path + "]";
    }
}

