/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.Translator;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.platform.bukkit.BukkitComponentSerializer;
import net.kyori.adventure.platform.bukkit.MinecraftComponentSerializer;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class Messaging {
    private static BukkitAudiences AUDIENCES;
    private static final Pattern CHAT_NEWLINE;
    private static final Splitter CHAT_NEWLINE_SPLITTER;
    private static final Map<String, String> COLORCODE_CONVERTER;
    private static boolean DEBUG;
    private static Logger DEBUG_LOGGER;
    private static String ERROR_COLOUR;
    private static final Pattern ERROR_MATCHER;
    private static final Pattern HEX_CODE_MATCHER;
    private static final Pattern HEX_MATCHER;
    private static String HIGHLIGHT_COLOUR;
    private static final Pattern HIGHLIGHT_MATCHER;
    private static final Pattern LEGACY_COLORCODE_MATCHER;
    private static Logger LOGGER;
    private static String MESSAGE_COLOUR;
    private static MiniMessage MINIMESSAGE;
    private static Pattern MINIMESSAGE_COLORCODE_MATCHER;
    private static final Joiner SPACE;
    private static final Pattern TRANSLATION_MATCHER;

    public static void configure(File debugFile, boolean debug, String messageColour, String highlightColour, String errorColour) {
        DEBUG = debug;
        MESSAGE_COLOUR = messageColour.replace("<a>", "<green>");
        HIGHLIGHT_COLOUR = highlightColour.replace("<e>", "yellow").replace("<yellow>", "yellow");
        ERROR_COLOUR = errorColour.replace("<c>", "<red>");
        if (Bukkit.getLogger() != null) {
            DEBUG_LOGGER = LOGGER = Bukkit.getLogger();
        }
        if (CitizensAPI.getPlugin() != null) {
            try {
                if (MinecraftComponentSerializer.isSupported()) {
                    AUDIENCES = BukkitAudiences.create((Plugin)CitizensAPI.getPlugin());
                } else {
                    Messaging.log("Unable to load Adventure, chat components will not work");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (debugFile != null) {
            DEBUG_LOGGER = Logger.getLogger("CitizensDebug");
            try {
                FileHandler fh = new FileHandler(debugFile.getAbsolutePath(), true);
                fh.setFormatter(new DebugFormatter());
                DEBUG_LOGGER.setUseParentHandlers(false);
                DEBUG_LOGGER.addHandler(fh);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String convertLegacyCodes(String message) {
        if (message == null) {
            return null;
        }
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        Matcher m = HEX_MATCHER.matcher(message);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "<#$1$2$3$4$5$6>");
        }
        m.appendTail(sb);
        m = HEX_CODE_MATCHER.matcher(sb.toString());
        sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "<$1>");
        }
        m.appendTail(sb);
        m = LEGACY_COLORCODE_MATCHER.matcher(sb.toString());
        sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, COLORCODE_CONVERTER.get(m.group(1) == null ? m.group(2).toLowerCase(Locale.ROOT) : m.group(1).toLowerCase(Locale.ROOT)));
        }
        m.appendTail(sb);
        return MINIMESSAGE_COLORCODE_MATCHER.matcher(sb.toString()).replaceAll("$0<csr>");
    }

    public static void debug(Object ... msg) {
        if (Messaging.isDebugging()) {
            DEBUG_LOGGER.log(Level.INFO, "[Citizens] " + SPACE.join(msg));
        }
    }

    public static void idebug(Supplier<String> msg) {
        if (Messaging.isDebugging()) {
            DEBUG_LOGGER.log(Level.INFO, "[Citizens] " + msg.get());
        }
    }

    public static boolean isDebugging() {
        return DEBUG;
    }

    private static void log(Level level, Object ... msg) {
        LOGGER.log(level, "[Citizens] " + SPACE.join(msg));
    }

    public static void log(Object ... msg) {
        Messaging.log(Level.INFO, msg);
    }

    public static void logTr(String key, Object ... msg) {
        Messaging.log(Level.INFO, Translator.translate(key, msg));
    }

    public static Object minecraftComponentFromRawMessage(String raw) {
        if (AUDIENCES != null && MINIMESSAGE != null) {
            return MinecraftComponentSerializer.get().serialize(MINIMESSAGE.deserialize((Object)Messaging.convertLegacyCodes(raw)));
        }
        return null;
    }

    public static String parseComponents(String raw) {
        if (AUDIENCES != null && MINIMESSAGE != null) {
            return BukkitComponentSerializer.legacy().serialize(MINIMESSAGE.deserialize((Object)Messaging.convertLegacyCodes(raw)));
        }
        return Messaging.convertLegacyCodes(raw);
    }

    private static String prettify(String message) {
        String trimmed = message.trim();
        String messageColour = MESSAGE_COLOUR;
        String parsed = Messaging.convertLegacyCodes(trimmed);
        if (!parsed.isEmpty()) {
            if (parsed.charAt(0) == '\u00a7') {
                ChatColor test = ChatColor.getByChar((String)parsed.substring(1, 2));
                if (test == null) {
                    message = messageColour + message;
                } else {
                    messageColour = test.toString();
                }
            } else {
                message = messageColour + message;
            }
        }
        message = CHAT_NEWLINE.matcher(message).replaceAll("<reset><br>]]");
        message = HIGHLIGHT_MATCHER.matcher(message).replaceAll("<" + HIGHLIGHT_COLOUR + ">");
        message = ERROR_MATCHER.matcher(message).replaceAll(ERROR_COLOUR);
        return message.replace("]]", MESSAGE_COLOUR);
    }

    public static void send(CommandSender sender, Object ... msg) {
        Messaging.sendMessageTo(sender, SPACE.join(msg), true);
    }

    public static void sendColorless(CommandSender sender, Object ... msg) {
        Messaging.sendMessageTo(sender, SPACE.join(msg), false);
    }

    public static void sendError(CommandSender sender, Object ... msg) {
        Messaging.send(sender, ERROR_COLOUR + SPACE.join(msg));
    }

    public static void sendErrorTr(CommandSender sender, String key, Object ... msg) {
        Messaging.send(sender, ERROR_COLOUR + Translator.translate(key, msg));
    }

    private static void sendMessageTo(CommandSender sender, String rawMessage, boolean messageColor) {
        for (String message : CHAT_NEWLINE_SPLITTER.split((CharSequence)rawMessage)) {
            if (messageColor) {
                message = Messaging.prettify(message);
            }
            if (AUDIENCES != null) {
                AUDIENCES.sender(sender).sendMessage(MINIMESSAGE.deserialize((Object)Messaging.convertLegacyCodes(message)));
                continue;
            }
            sender.sendMessage(Messaging.convertLegacyCodes(rawMessage));
        }
    }

    public static void sendTr(CommandSender sender, String key, Object ... msg) {
        Messaging.sendMessageTo(sender, Translator.translate(key, msg), true);
    }

    public static void sendTrColorless(CommandSender sender, String key, Object ... msg) {
        Messaging.sendMessageTo(sender, Translator.translate(key, msg), false);
    }

    public static void sendWithNPC(CommandSender sender, Object msg, NPC npc) {
        Messaging.sendMessageTo(sender, Placeholders.replace(msg.toString(), sender, npc), true);
    }

    public static void sendWithNPCColorless(CommandSender sender, Object msg, NPC npc) {
        Messaging.sendMessageTo(sender, Placeholders.replace(msg.toString(), sender, npc), false);
    }

    public static void severe(Object ... messages) {
        Messaging.log(Level.SEVERE, messages);
    }

    public static void severeTr(String key, Object ... messages) {
        Messaging.log(Level.SEVERE, Translator.translate(key, messages));
    }

    public static String stripColor(String raw) {
        raw = ChatColor.stripColor((String)Messaging.convertLegacyCodes(raw));
        if (AUDIENCES != null && MINIMESSAGE != null) {
            return MINIMESSAGE.stripTags(raw);
        }
        return raw;
    }

    public static String tr(String key, Object ... messages) {
        return Messaging.prettify(Translator.translate(key, messages));
    }

    public static String tryTranslate(Object possible) {
        if (possible == null) {
            return "";
        }
        String message = possible.toString();
        return TRANSLATION_MATCHER.matcher(message).find() ? Messaging.tr(message, new Object[0]) : message;
    }

    static {
        CHAT_NEWLINE = Pattern.compile("<br>|\\n", 8);
        CHAT_NEWLINE_SPLITTER = Splitter.on((Pattern)CHAT_NEWLINE);
        COLORCODE_CONVERTER = Maps.newHashMap();
        DEBUG = false;
        ERROR_COLOUR = "<red>";
        ERROR_MATCHER = Pattern.compile("{{", 16);
        HEX_CODE_MATCHER = Pattern.compile("&(#[0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f])", 2);
        HEX_MATCHER = Pattern.compile("&x&([0-9a-f])&([0-9a-f])&([0-9a-f])&([0-9a-f])&([0-9a-f])&([0-9a-f])".replace('&', '\u00a7'), 2);
        HIGHLIGHT_COLOUR = "yellow";
        HIGHLIGHT_MATCHER = Pattern.compile("[[", 16);
        LEGACY_COLORCODE_MATCHER = Pattern.compile("\u00a7([0-9a-r])|<([0-9a-f])>", 2);
        LOGGER = Logger.getLogger("Citizens");
        MESSAGE_COLOUR = "<green>";
        SPACE = Joiner.on((String)" ").useForNull("null");
        TRANSLATION_MATCHER = Pattern.compile("^[a-zA-Z0-9]+\\.[a-zA-Z0-9]+\\.[a-zA-Z0-9.]+");
        COLORCODE_CONVERTER.put("0", "<black>");
        COLORCODE_CONVERTER.put("1", "<dark_blue>");
        COLORCODE_CONVERTER.put("2", "<dark_green>");
        COLORCODE_CONVERTER.put("3", "<dark_aqua>");
        COLORCODE_CONVERTER.put("4", "<dark_red>");
        COLORCODE_CONVERTER.put("5", "<dark_purple>");
        COLORCODE_CONVERTER.put("6", "<gold>");
        COLORCODE_CONVERTER.put("7", "<gray>");
        COLORCODE_CONVERTER.put("8", "<dark_gray>");
        COLORCODE_CONVERTER.put("9", "<blue>");
        COLORCODE_CONVERTER.put("a", "<green>");
        COLORCODE_CONVERTER.put("b", "<aqua>");
        COLORCODE_CONVERTER.put("c", "<red>");
        COLORCODE_CONVERTER.put("d", "<light_purple>");
        COLORCODE_CONVERTER.put("e", "<yellow>");
        COLORCODE_CONVERTER.put("f", "<white>");
        COLORCODE_CONVERTER.put("m", "<st>");
        COLORCODE_CONVERTER.put("n", "<u>");
        COLORCODE_CONVERTER.put("k", "<obf>");
        COLORCODE_CONVERTER.put("o", "<i>");
        COLORCODE_CONVERTER.put("l", "<b>");
        COLORCODE_CONVERTER.put("r", "<reset>");
        try {
            MINIMESSAGE_COLORCODE_MATCHER = Pattern.compile(Joiner.on((char)'|').join((Iterable)Collections2.transform((Collection)NamedTextColor.NAMES.values(), c -> '<' + c.toString() + '>')) + "|<#[a-f\\d]{6}>", 2);
            MINIMESSAGE = MiniMessage.builder().editTags(t -> t.resolver((TagResolver)TagResolver.resolver((String)"csr", (Tag)Tag.styling(s -> Arrays.stream(TextDecoration.values()).forEach(td -> s.decoration(td, false)))))).build();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class DebugFormatter
    extends Formatter {
        private final SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ");

        private DebugFormatter() {
        }

        @Override
        public String format(LogRecord rec) {
            Throwable exception = rec.getThrown();
            String out = this.date.format(rec.getMillis());
            out = out + "[" + rec.getLevel().getName().toUpperCase(Locale.ROOT) + "] ";
            out = out + rec.getMessage() + '\n';
            if (exception != null) {
                StringWriter writer = new StringWriter();
                exception.printStackTrace(new PrintWriter(writer));
                return out + writer;
            }
            return out;
        }
    }
}

