/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.npc.MetadataStore;
import net.citizensnpcs.api.util.DataKey;

public class SimpleMetadataStore
implements MetadataStore {
    private final Map<String, MetadataObject> metadata = Maps.newHashMap();

    private void checkPrimitive(Object data) {
        boolean isPrimitive;
        Preconditions.checkNotNull((Object)data, (Object)"data cannot be null");
        boolean bl = isPrimitive = data instanceof String || data instanceof Boolean || data instanceof Number;
        if (!isPrimitive) {
            throw new IllegalArgumentException("data is not primitive");
        }
    }

    @Override
    public <T> T get(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        MetadataObject normal = this.metadata.get(key);
        return (T)(normal == null ? null : normal.value);
    }

    @Override
    public <T> T get(String key, T def) {
        T t = this.get(key);
        if (t == null) {
            this.set(key, def);
            return def;
        }
        return t;
    }

    @Override
    public boolean has(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        return this.metadata.containsKey(key);
    }

    @Override
    public void loadFrom(DataKey key) {
        for (Map.Entry<String, MetadataObject> entry : this.metadata.entrySet()) {
            if (!entry.getValue().persistent) continue;
            this.metadata.remove(key);
        }
        for (DataKey subKey : key.getSubKeys()) {
            this.metadata.put(subKey.name(), new MetadataObject(subKey.getRaw(""), true));
        }
    }

    @Override
    public void remove(String key) {
        this.metadata.remove(key);
    }

    @Override
    public void saveTo(DataKey key) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        for (Map.Entry<String, MetadataObject> entry : this.metadata.entrySet()) {
            if (!entry.getValue().persistent) continue;
            key.setRaw(entry.getKey(), entry.getValue().value);
        }
    }

    @Override
    public void set(String key, Object data) {
        Preconditions.checkNotNull((Object)data, (Object)"data cannot be null");
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        this.metadata.put(key, new MetadataObject(data, false));
    }

    @Override
    public void setPersistent(String key, Object data) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        this.checkPrimitive(data);
        this.metadata.put(key, new MetadataObject(data, true));
    }

    private static class MetadataObject {
        boolean persistent;
        Object value;

        public MetadataObject(Object raw, boolean persistent) {
            this.value = raw;
            this.persistent = persistent;
        }
    }
}

