/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import net.citizensnpcs.api.astar.AStarGoal;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.AStarStorage;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.SimpleAStarStorage;

public class AStarMachine {
    private Supplier<AStarStorage> storageSupplier;

    private AStarMachine(Supplier<AStarStorage> storage) {
        this.storageSupplier = storage;
    }

    private void f(AStarGoal goal, AStarNode node, AStarNode neighbour) {
        float g = node.g + goal.g(node, neighbour);
        float h = goal.h(neighbour);
        neighbour.f = g + h;
        neighbour.g = g;
        neighbour.h = h;
    }

    private AStarStorage getInitialisedStorage(AStarGoal goal, AStarNode start) {
        AStarStorage storage = (AStarStorage)this.storageSupplier.get();
        storage.open(start);
        start.f = goal.getInitialCost(start);
        return storage;
    }

    public AStarState getStateFor(AStarGoal<?> goal, AStarNode start) {
        return new AStarState(goal, start, this.getInitialisedStorage(goal, start));
    }

    public <T extends Plan> T run(AStarState state) {
        return this.run(state, -1);
    }

    public <T extends Plan> T run(AStarState state, int maxIterations) {
        return this.run(state.storage, state.goal, state.start, maxIterations);
    }

    private <T extends Plan> T run(AStarStorage storage, AStarGoal goal, AStarNode start, int maxIterations) {
        Preconditions.checkNotNull((Object)goal);
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)storage);
        int iterations = 0;
        do {
            AStarNode node;
            if ((node = storage.removeBestNode()) == null) {
                return null;
            }
            if (goal.isFinished(node)) {
                return (T)node.buildPlan();
            }
            storage.close(node);
            for (AStarNode neighbour : node.getNeighbours()) {
                this.f(goal, node, neighbour);
                if (!storage.shouldExamine(neighbour)) continue;
                storage.open(neighbour);
                neighbour.parent = node;
            }
        } while (maxIterations < 0 || iterations++ < maxIterations);
        return null;
    }

    public <T extends Plan> T runFully(AStarGoal<?> goal, AStarNode start) {
        return this.runFully(goal, start, -1);
    }

    public <T extends Plan> T runFully(AStarGoal<?> goal, AStarNode start, int iterations) {
        return this.run(this.getInitialisedStorage(goal, start), goal, start, iterations);
    }

    public void setStorageSupplier(Supplier<AStarStorage> newSupplier) {
        this.storageSupplier = newSupplier;
    }

    public static AStarMachine createWithDefaultStorage() {
        return AStarMachine.createWithStorage(SimpleAStarStorage.FACTORY);
    }

    public static AStarMachine createWithStorage(Supplier<AStarStorage> storageSupplier) {
        return new AStarMachine(storageSupplier);
    }

    public static class AStarState {
        private final AStarGoal<?> goal;
        private final AStarNode start;
        private final AStarStorage storage;

        private AStarState(AStarGoal<?> goal, AStarNode start, AStarStorage storage) {
            this.goal = goal;
            this.start = start;
            this.storage = storage;
        }

        public <T extends AStarNode> T getBestNode() {
            return (T)this.storage.getBestNode();
        }
    }
}

