/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.Composite;
import net.citizensnpcs.api.ai.tree.ParallelBehavior;

public class Sequence
extends Composite {
    private Behavior executing;
    private int executingIndex;
    private final boolean retryChildren;

    private Sequence(boolean retryChildren, Behavior ... behaviors) {
        this(retryChildren, Arrays.asList(behaviors));
    }

    private Sequence(boolean retryChildren, Collection<Behavior> behaviors) {
        super(behaviors);
        this.retryChildren = retryChildren;
    }

    private BehaviorStatus getContinuationStatus() {
        this.resetCurrent();
        if (this.retryChildren) {
            ++this.executingIndex;
            return BehaviorStatus.RUNNING;
        }
        return BehaviorStatus.FAILURE;
    }

    @Override
    public void reset() {
        super.reset();
        this.resetCurrent();
        this.executingIndex = 0;
    }

    private void resetCurrent() {
        this.stopExecution(this.executing);
        this.executing = null;
    }

    @Override
    public BehaviorStatus run() {
        BehaviorStatus next;
        this.tickParallel();
        List<Behavior> behaviors = this.getBehaviors();
        if (this.executing == null && (next = this.selectNext(behaviors)) != BehaviorStatus.RUNNING) {
            this.resetCurrent();
            return next;
        }
        BehaviorStatus status = this.executing.run();
        switch (status) {
            case RUNNING: {
                return BehaviorStatus.RUNNING;
            }
            case FAILURE: {
                return this.getContinuationStatus();
            }
            case RESET_AND_REMOVE: {
                behaviors.remove(this.executingIndex);
                return this.selectNext(behaviors);
            }
            case SUCCESS: {
                this.resetCurrent();
                ++this.executingIndex;
                return this.selectNext(behaviors);
            }
        }
        throw new IllegalStateException();
    }

    private BehaviorStatus selectNext(List<Behavior> behaviors) {
        if (this.executingIndex >= behaviors.size()) {
            return BehaviorStatus.SUCCESS;
        }
        while ((this.executing = behaviors.get(this.executingIndex)) instanceof ParallelBehavior) {
            this.addParallel(this.executing);
            if (++this.executingIndex < behaviors.size()) continue;
            return BehaviorStatus.SUCCESS;
        }
        if (!this.executing.shouldExecute()) {
            return this.getContinuationStatus();
        }
        this.prepareForExecution(this.executing);
        return BehaviorStatus.RUNNING;
    }

    public String toString() {
        return "Sequence [executing=" + this.executing + ", executingIndex=" + this.executingIndex + ", retryChildren=" + this.retryChildren + ", getBehaviors()=" + this.getBehaviors() + "]";
    }

    public static Sequence createRetryingSequence(Behavior ... behaviors) {
        return Sequence.createRetryingSequence(Arrays.asList(behaviors));
    }

    public static Sequence createRetryingSequence(Collection<Behavior> behaviors) {
        return new Sequence(true, behaviors);
    }

    public static Sequence createSequence(Behavior ... behaviors) {
        return Sequence.createSequence(Arrays.asList(behaviors));
    }

    public static Sequence createSequence(Collection<Behavior> behaviors) {
        return new Sequence(false, behaviors);
    }
}

