/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import com.google.common.base.Function;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.Composite;
import net.citizensnpcs.api.ai.tree.ParallelBehavior;

public class Selector
extends Composite {
    private Behavior executing;
    private boolean retryChildren = false;
    private final Function<List<Behavior>, Behavior> selectionFunction;
    private static final Random RANDOM = new Random();
    private static final Function<List<Behavior>, Behavior> RANDOM_SELECTION = new Function<List<Behavior>, Behavior>(){

        public Behavior apply(@Nullable List<Behavior> behaviors) {
            return behaviors.get(RANDOM.nextInt(behaviors.size()));
        }
    };

    private Selector(Function<List<Behavior>, Behavior> selectionFunction, boolean retryChildren, Collection<Behavior> behaviors) {
        super(behaviors);
        this.selectionFunction = selectionFunction;
        this.retryChildren = retryChildren;
    }

    public Behavior getNextBehavior() {
        Behavior behavior = null;
        while ((behavior = (Behavior)this.selectionFunction.apply(this.getBehaviors())) instanceof ParallelBehavior) {
            this.addParallel(behavior);
        }
        return behavior;
    }

    public Function<List<Behavior>, Behavior> getSelectionFunction() {
        return this.selectionFunction;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.executing != null) {
            this.stopExecution(this.executing);
        }
        this.executing = null;
    }

    public boolean retryChildren() {
        return this.retryChildren;
    }

    @Override
    public BehaviorStatus run() {
        this.tickParallel();
        BehaviorStatus status = null;
        if (this.executing == null) {
            this.executing = this.getNextBehavior();
            if (this.executing == null) {
                return BehaviorStatus.FAILURE;
            }
            if (this.executing.shouldExecute()) {
                this.prepareForExecution(this.executing);
            } else {
                status = BehaviorStatus.FAILURE;
            }
        }
        if (status == null) {
            status = this.executing.run();
        }
        if (status == BehaviorStatus.FAILURE) {
            if (this.retryChildren) {
                this.stopExecution(this.executing);
                this.executing = null;
                return BehaviorStatus.RUNNING;
            }
        } else if (status == BehaviorStatus.RESET_AND_REMOVE) {
            this.getBehaviors().remove(this.executing);
            this.stopExecution(this.executing);
            this.executing = null;
            return BehaviorStatus.SUCCESS;
        }
        return status;
    }

    public String toString() {
        return "Selector [executing=" + this.executing + ", retryChildren=" + this.retryChildren + ", selectionFunction=" + this.selectionFunction + ", getBehaviors()=" + this.getBehaviors() + "]";
    }

    public static Builder selecting(Behavior ... behaviors) {
        return Selector.selecting(Arrays.asList(behaviors));
    }

    public static Builder selecting(Collection<Behavior> behaviors) {
        return new Builder(behaviors);
    }

    static /* synthetic */ Function access$000() {
        return RANDOM_SELECTION;
    }

    public static class Builder {
        private final Collection<Behavior> behaviors;
        private boolean retryChildren;
        private Function<List<Behavior>, Behavior> selectionFunction = Selector.access$000();

        private Builder(Collection<Behavior> behaviors) {
            this.behaviors = behaviors;
        }

        public Selector build() {
            return new Selector(this.selectionFunction, this.retryChildren, this.behaviors);
        }

        public Builder retryChildren() {
            this.retryChildren = true;
            return this;
        }

        public Builder retryChildren(boolean b) {
            this.retryChildren = b;
            return this;
        }

        public Builder selectionFunction(Function<List<Behavior>, Behavior> function) {
            this.selectionFunction = function;
            return this;
        }
    }
}

