/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util.prtree;

import java.util.Comparator;
import net.citizensnpcs.api.util.prtree.MBRConverter;
import net.citizensnpcs.api.util.prtree.Node;
import net.citizensnpcs.api.util.prtree.NodeComparators;

class InternalNodeComparators<T>
implements NodeComparators<Node<T>> {
    private final MBRConverter<T> converter;

    public InternalNodeComparators(MBRConverter<T> converter) {
        this.converter = converter;
    }

    @Override
    public Comparator<Node<T>> getMaxComparator(final int axis) {
        return new Comparator<Node<T>>(){

            @Override
            public int compare(Node<T> n1, Node<T> n2) {
                double d1 = n1.getMBR(InternalNodeComparators.this.converter).getMax(axis);
                double d2 = n2.getMBR(InternalNodeComparators.this.converter).getMax(axis);
                return Double.compare(d1, d2);
            }
        };
    }

    @Override
    public Comparator<Node<T>> getMinComparator(final int axis) {
        return new Comparator<Node<T>>(){

            @Override
            public int compare(Node<T> n1, Node<T> n2) {
                double d1 = n1.getMBR(InternalNodeComparators.this.converter).getMin(axis);
                double d2 = n2.getMBR(InternalNodeComparators.this.converter).getMin(axis);
                return Double.compare(d1, d2);
            }
        };
    }
}

