/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.ai.event.NavigatorCallback;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class MinecraftBlockExaminer
implements BlockExaminer {
    private static final Vector DOWN = new Vector(0, -1, 0);
    private static final Set<Material> NOT_JUMPABLE = EnumSet.of(Material.FENCE, Material.IRON_FENCE, Material.NETHER_FENCE);
    private static final Set<Material> PASSABLE = EnumSet.of(Material.AIR, new Material[]{Material.DEAD_BUSH, Material.DETECTOR_RAIL, Material.DIODE, Material.DIODE_BLOCK_OFF, Material.DIODE_BLOCK_ON, Material.FENCE_GATE, Material.ITEM_FRAME, Material.LEVER, Material.LONG_GRASS, Material.CARPET, Material.MELON_STEM, Material.NETHER_FENCE, Material.PUMPKIN_STEM, Material.POWERED_RAIL, Material.RAILS, Material.RED_ROSE, Material.RED_MUSHROOM, Material.REDSTONE, Material.REDSTONE_TORCH_OFF, Material.REDSTONE_TORCH_OFF, Material.REDSTONE_WIRE, Material.SIGN, Material.SIGN_POST, Material.SNOW, Material.DOUBLE_PLANT, Material.STRING, Material.STONE_BUTTON, Material.SUGAR_CANE_BLOCK, Material.TRIPWIRE, Material.VINE, Material.WALL_SIGN, Material.WHEAT, Material.WATER, Material.WEB, Material.WOOD_BUTTON, Material.WOODEN_DOOR, Material.STATIONARY_WATER});
    private static final Set<Material> UNWALKABLE = EnumSet.of(Material.AIR, Material.LAVA, Material.STATIONARY_LAVA, Material.CACTUS);
    private static final Vector UP = new Vector(0, 1, 0);

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        Material above = source.getMaterialAt(pos.clone().add(UP));
        Material below = source.getMaterialAt(pos.clone().add(DOWN));
        Material in = source.getMaterialAt(pos);
        if (above == Material.WEB || in == Material.WEB) {
            return 1.0f;
        }
        if (below == Material.SOUL_SAND || below == Material.ICE) {
            return 1.0f;
        }
        if (MinecraftBlockExaminer.isLiquid(above, below, in)) {
            return 0.5f;
        }
        return 0.5f;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        Material above = source.getMaterialAt(pos.clone().add(UP));
        Material below = source.getMaterialAt(pos.clone().add(DOWN));
        Material in = source.getMaterialAt(pos);
        if (!below.isBlock() || !MinecraftBlockExaminer.canStandOn(below)) {
            return BlockExaminer.PassableState.UNPASSABLE;
        }
        if (above == Material.LADDER && in == Material.LADDER || in == Material.LADDER && below == Material.LADDER) {
            point.addCallback(new LadderClimber());
        } else if (!MinecraftBlockExaminer.canStandIn(above) || !MinecraftBlockExaminer.canStandIn(in)) {
            return BlockExaminer.PassableState.UNPASSABLE;
        }
        if (!MinecraftBlockExaminer.canJumpOn(below)) {
            if (point.getParentPoint() == null) {
                return BlockExaminer.PassableState.UNPASSABLE;
            }
            Vector parentPos = point.getParentPoint().getVector();
            if ((parentPos.getX() != pos.getX() || parentPos.getZ() != pos.getZ()) && pos.clone().subtract(point.getParentPoint().getVector()).getY() == 1.0) {
                return BlockExaminer.PassableState.UNPASSABLE;
            }
        }
        return BlockExaminer.PassableState.PASSABLE;
    }

    private static boolean canJumpOn(Material mat) {
        return !NOT_JUMPABLE.contains(mat);
    }

    public static boolean canStandIn(Material ... mat) {
        return PASSABLE.containsAll(Arrays.asList(mat));
    }

    public static boolean canStandOn(Block block) {
        Block up = block.getRelative(BlockFace.UP);
        return MinecraftBlockExaminer.canStandOn(block.getType()) && MinecraftBlockExaminer.canStandIn(up.getType()) && MinecraftBlockExaminer.canStandIn(up.getRelative(BlockFace.UP).getType());
    }

    public static boolean canStandOn(Material mat) {
        return !UNWALKABLE.contains(mat) && !PASSABLE.contains(mat);
    }

    private static boolean contains(Material[] search, Material ... find) {
        for (Material haystack : search) {
            for (Material needle : find) {
                if (haystack != needle) continue;
                return true;
            }
        }
        return false;
    }

    public static Location findValidLocation(Location location, int radius) {
        Block base = location.getBlock();
        if (MinecraftBlockExaminer.canStandIn(base.getType()) && MinecraftBlockExaminer.canStandOn(base.getRelative(BlockFace.DOWN))) {
            return location;
        }
        for (int y = 0; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    Block relative = base.getRelative(x, y, z);
                    if (!MinecraftBlockExaminer.canStandIn(relative.getRelative(BlockFace.UP).getType()) || !MinecraftBlockExaminer.canStandIn(relative.getType()) || !MinecraftBlockExaminer.canStandOn(base.getRelative(BlockFace.DOWN))) continue;
                    return relative.getLocation();
                }
            }
        }
        return location;
    }

    public static boolean isLiquid(Material ... materials) {
        return MinecraftBlockExaminer.contains(materials, Material.WATER, Material.STATIONARY_WATER, Material.LAVA, Material.STATIONARY_LAVA);
    }

    public static boolean validPosition(Block in) {
        return MinecraftBlockExaminer.canStandIn(in.getType()) && MinecraftBlockExaminer.canStandIn(in.getRelative(BlockFace.UP).getType()) && MinecraftBlockExaminer.canStandOn(in.getRelative(BlockFace.DOWN));
    }

    private final class LadderClimber
    implements PathPoint.PathCallback {
        boolean added = false;

        private LadderClimber() {
        }

        @Override
        public void run(final NPC npc, Block point, double radius) {
            if (this.added || npc.data().get("running-ladder", false).booleanValue()) {
                this.added = true;
                return;
            }
            Runnable callback = new Runnable(){
                Location dummy = new Location(null, 0.0, 0.0, 0.0);

                @Override
                public void run() {
                    if (npc.getEntity().getLocation(this.dummy).getBlock().getType() == Material.LADDER) {
                        npc.getEntity().setVelocity(npc.getEntity().getVelocity().setY(0.3));
                    }
                }
            };
            npc.getNavigator().getLocalParameters().addSingleUseCallback(new NavigatorCallback(){

                @Override
                public void onCompletion(CancelReason cancelReason) {
                    npc.data().set("running-ladder", false);
                }
            });
            npc.getNavigator().getLocalParameters().addRunCallback(callback);
            this.added = true;
        }
    }
}

