/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import net.citizensnpcs.api.util.Colorizer;
import net.citizensnpcs.api.util.Messaging;

public class Translator {
    private final Locale defaultLocale;
    private final Map<String, MessageFormat> messageFormatCache = Maps.newHashMap();
    private ResourceBundle preferredBundle;
    private final File resourceFile;
    private static ResourceBundle defaultBundle;
    private static Translator instance;
    public static final String PREFIX = "messages";

    private Translator(File resourceFile, Locale locale) {
        this.resourceFile = resourceFile;
        this.defaultLocale = locale;
        try {
            this.preferredBundle = ResourceBundle.getBundle(PREFIX, this.defaultLocale, new FileClassLoader(Translator.class.getClassLoader(), resourceFile));
        }
        catch (MissingResourceException e) {
            this.preferredBundle = this.getDefaultBundle();
            Messaging.severe("Missing preferred location bundle.");
        }
    }

    private String format(String key, Locale locale, Object ... msg) {
        String unreplaced = this.translate(key, locale);
        MessageFormat formatter = this.getFormatter(unreplaced);
        return formatter.format(msg);
    }

    private ResourceBundle getBundle(Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(PREFIX, locale, new FileClassLoader(Translator.class.getClassLoader(), this.resourceFile));
            return bundle == null ? this.preferredBundle : bundle;
        }
        catch (MissingResourceException e) {
            return this.preferredBundle;
        }
    }

    private ResourceBundle getDefaultBundle() {
        return Translator.getDefaultResourceBundle(this.resourceFile, "messages_en.properties");
    }

    private MessageFormat getFormatter(String unreplaced) {
        MessageFormat formatter = this.messageFormatCache.get(unreplaced);
        if (formatter == null) {
            formatter = new MessageFormat(unreplaced);
            this.messageFormatCache.put(unreplaced, formatter);
        }
        return formatter;
    }

    private String translate(String key, Locale locale) {
        ResourceBundle bundle = this.preferredBundle;
        if (locale != this.defaultLocale) {
            bundle = this.getBundle(locale);
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            try {
                return this.getDefaultBundle().getString(key);
            }
            catch (MissingResourceException ex) {
                return "?" + key + "?";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTranslation(TranslationProvider from, File to) {
        Properties props = new Properties();
        InputStream in = from.createInputStream();
        try {
            props.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            Closeables.closeQuietly((InputStream)in);
        }
        if (to.exists()) {
            try {
                in = new FileInputStream(to);
                props.load(in);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                Closeables.closeQuietly((InputStream)in);
            }
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(to);
            props.store(out, "");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (Exception e) {
                e.getCause();
            }
        }
    }

    public static void addTranslations(Collection<TranslationProvider> providers) {
        for (TranslationProvider provider : providers) {
            Translator.addTranslation(provider, new File(Translator.instance.resourceFile, provider.getName()));
        }
        defaultBundle = null;
        Translator.setInstance(Translator.instance.resourceFile, Translator.instance.preferredBundle.getLocale());
    }

    public static void addTranslations(TranslationProvider ... providers) {
        Translator.addTranslations(Arrays.asList(providers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getDefaultBundleProperties() {
        Properties defaults = new Properties();
        InputStream in = null;
        try {
            in = Translator.class.getResourceAsStream("/messages_en.properties");
            defaults.load(in);
        }
        catch (IOException iOException) {
        }
        finally {
            Closeables.closeQuietly((InputStream)in);
        }
        return defaults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle getDefaultResourceBundle(File resourceDirectory, String fileName) {
        if (defaultBundle != null) {
            return defaultBundle;
        }
        resourceDirectory.mkdirs();
        File bundleFile = new File(resourceDirectory, fileName);
        if (!bundleFile.exists()) {
            try {
                bundleFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Translator.populateDefaults(bundleFile);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(bundleFile);
            defaultBundle = new PropertyResourceBundle(stream);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                defaultBundle = Translator.getFallbackResourceBundle();
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(stream);
                throw throwable;
            }
            Closeables.closeQuietly((InputStream)stream);
        }
        Closeables.closeQuietly((InputStream)stream);
        return defaultBundle;
    }

    private static ResourceBundle getFallbackResourceBundle() {
        return new ListResourceBundle(){

            @Override
            protected Object[][] getContents() {
                return new Object[0][0];
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void populateDefaults(File bundleFile) {
        Properties properties = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(bundleFile);
            properties.load(in);
        }
        catch (IOException e) {
            Closeables.closeQuietly((InputStream)in);
            catch (Throwable throwable) {
                Closeables.closeQuietly(in);
                throw throwable;
            }
        }
        Closeables.closeQuietly((InputStream)in);
        Properties defaults = Translator.getDefaultBundleProperties();
        for (Map.Entry<Object, Object> entry : defaults.entrySet()) {
            if (properties.containsKey(entry.getKey())) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(bundleFile);
            properties.store(stream, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stream != null) {
                    ((OutputStream)stream).close();
                }
            }
            catch (Exception e) {
                e.getCause();
            }
        }
    }

    public static void setInstance(File dataFolder, Locale preferredLocale) {
        instance = new Translator(dataFolder, preferredLocale);
    }

    public static String translate(String key, Locale preferredLocale, Object ... msg) {
        return Colorizer.parseColors(msg.length == 0 ? instance.translate(key, preferredLocale) : instance.format(key, preferredLocale, msg));
    }

    public static String translate(String key, Object ... msg) {
        return Translator.translate(key, Translator.instance.defaultLocale, msg);
    }

    public static interface TranslationProvider {
        public InputStream createInputStream();

        public String getName();
    }

    private static class SaveResource
    implements Runnable {
        private final String fileName;
        private final File rootFolder;

        private SaveResource(File rootFolder, String fileName) {
            this.rootFolder = rootFolder;
            this.fileName = fileName;
        }

        @Override
        public void run() {
            File file = new File(this.rootFolder, this.fileName);
            if (file.exists()) {
                return;
            }
            try {
                this.rootFolder.mkdirs();
                File to = File.createTempFile(this.fileName, null, this.rootFolder);
                to.deleteOnExit();
                Resources.asByteSource((URL)Resources.getResource(Translator.class, (String)('/' + this.fileName))).copyTo(Files.asByteSink((File)to, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}));
                if (!file.exists()) {
                    to.renameTo(file);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class FileClassLoader
    extends ClassLoader {
        private final File folder;

        public FileClassLoader(ClassLoader classLoader, File folder) {
            super(classLoader);
            this.folder = folder;
        }

        @Override
        public URL getResource(String string) {
            File file = new File(this.folder, string);
            if (file.exists()) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException ex) {
                }
            } else {
                string = string.replaceFirst("/", "");
                URL test = Translator.class.getResource('/' + string);
                if (test != null) {
                    return test;
                }
            }
            return super.getResource(string);
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            File file = new File(this.folder, string);
            if (file.exists()) {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException ex) {
                }
            } else {
                string = string.replaceFirst("/", "");
                InputStream stream = Translator.class.getResourceAsStream('/' + string);
                if (stream != null) {
                    new Thread(new SaveResource(this.folder, string)).start();
                    return stream;
                }
            }
            return super.getResourceAsStream(string);
        }
    }
}

