/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import net.citizensnpcs.api.astar.Agent;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Path
implements Plan {
    private int index = 0;
    private final PathEntry[] path;

    Path(Iterable<VectorNode> unfiltered) {
        this.path = this.cull(unfiltered);
    }

    private PathEntry[] cull(Iterable<VectorNode> unfiltered) {
        ArrayList path = Lists.newArrayList();
        for (VectorNode node : unfiltered) {
            Vector vector = node.location;
            path.add(new PathEntry(vector, node.callbacks));
        }
        return path.toArray(new PathEntry[path.size()]);
    }

    public void debug() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            for (PathEntry entry : this.path) {
                player.sendBlockChange(entry.vector.toLocation(player.getWorld()), Material.YELLOW_FLOWER, (byte)0);
            }
        }
    }

    public void debugEnd() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            for (PathEntry entry : this.path) {
                Block block = entry.vector.toLocation(player.getWorld()).getBlock();
                player.sendBlockChange(block.getLocation(), block.getType(), block.getData());
            }
        }
    }

    public Vector getCurrentVector() {
        return this.path[this.index].vector;
    }

    @Override
    public boolean isComplete() {
        return this.index >= this.path.length;
    }

    public void run(NPC npc) {
        this.path[this.index].run(npc);
    }

    public String toString() {
        return Arrays.toString(this.path);
    }

    @Override
    public void update(Agent agent) {
        if (this.isComplete()) {
            return;
        }
        ++this.index;
    }

    private class PathEntry {
        final List<PathPoint.PathCallback> callbacks;
        final Vector vector;

        private PathEntry(Vector vector, List<PathPoint.PathCallback> callbacks) {
            this.vector = vector;
            this.callbacks = callbacks;
        }

        private Block getBlockUsingWorld(World world) {
            return world.getBlockAt(this.vector.getBlockX(), this.vector.getBlockY(), this.vector.getBlockZ());
        }

        public void run(final NPC npc) {
            if (this.callbacks != null) {
                Block block = this.getBlockUsingWorld(npc.getEntity().getWorld());
                for (PathPoint.PathCallback callback : this.callbacks) {
                    ListIterator<Block> vec = Lists.transform(Arrays.asList(Path.this.path), (Function)new Function<PathEntry, Block>(){

                        public Block apply(PathEntry input) {
                            return npc.getEntity().getWorld().getBlockAt(input.vector.getBlockX(), input.vector.getBlockY(), input.vector.getBlockZ());
                        }
                    }).listIterator();
                    if (Path.this.index > 0) {
                        while (Path.this.index != vec.nextIndex()) {
                            vec.next();
                        }
                    }
                    callback.run(npc, block, vec);
                }
            }
        }

        public String toString() {
            return this.vector.toString();
        }
    }
}

