/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import java.util.Arrays;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.ItemStorage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

@TraitName(value="inventory")
public class Inventory
extends Trait {
    private ItemStack[] contents = new ItemStack[72];
    private org.bukkit.inventory.Inventory view;

    public Inventory() {
        super("inventory");
    }

    public ItemStack[] getContents() {
        return this.contents;
    }

    public org.bukkit.inventory.Inventory getInventoryView() {
        return this.view;
    }

    @EventHandler
    public void inventoryEvent(InventoryEvent event) {
        if (this.view != null && event.getInventory().equals(this.view)) {
            this.contents = event.getInventory().getContents();
        }
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.contents = this.parseContents(key);
    }

    @Override
    public void onSpawn() {
        this.setContents(this.contents);
        this.view = Bukkit.createInventory((InventoryHolder)(this.npc.getEntity() instanceof InventoryHolder ? (InventoryHolder)this.npc.getEntity() : null), (int)this.contents.length);
    }

    private ItemStack[] parseContents(DataKey key) throws NPCLoadException {
        ItemStack[] contents = new ItemStack[72];
        for (DataKey slotKey : key.getIntegerSubKeys()) {
            contents[Integer.parseInt((String)slotKey.name())] = ItemStorage.loadItemStack(slotKey);
        }
        return contents;
    }

    @Override
    public void run() {
        if (this.npc.getEntity() instanceof Player) {
            this.contents = ((Player)this.npc.getEntity()).getInventory().getContents();
        }
    }

    @Override
    public void save(DataKey key) {
        int slot = 0;
        for (ItemStack item : this.contents) {
            key.removeKey(String.valueOf(slot));
            if (item != null) {
                ItemStorage.saveItem(key.getRelative(String.valueOf(slot)), item);
            }
            ++slot;
        }
    }

    public void setContents(ItemStack[] contents) {
        this.contents = Arrays.copyOf(contents, 72);
        PlayerInventory dest = null;
        int maxCopySize = -1;
        if (this.npc.getEntity() instanceof Player) {
            dest = ((Player)this.npc.getEntity()).getInventory();
            maxCopySize = 36;
        } else if (this.npc.getEntity() instanceof StorageMinecart) {
            dest = ((StorageMinecart)this.npc.getEntity()).getInventory();
        } else if (this.npc.getEntity() instanceof Horse) {
            dest = ((Horse)this.npc.getEntity()).getInventory();
        }
        if (dest == null) {
            return;
        }
        if (maxCopySize == -1) {
            maxCopySize = dest.getSize();
        }
        for (int i = 0; i < maxCopySize; ++i) {
            dest.setItem(i, contents[i]);
        }
    }

    public String toString() {
        return "Inventory{" + Arrays.toString(this.contents) + "}";
    }
}

