/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.ItemStorage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

@TraitName(value="inventory")
public class Inventory
extends Trait {
    private ItemStack[] contents;
    private org.bukkit.inventory.Inventory view;
    private final Set<InventoryView> views = new HashSet<InventoryView>();

    public Inventory() {
        super("inventory");
        this.contents = new ItemStack[72];
    }

    public ItemStack[] getContents() {
        if (this.view != null) {
            for (int i = 0; i < this.view.getSize(); ++i) {
                this.view.setItem(i, this.contents[i]);
            }
            return this.view.getContents();
        }
        return this.contents;
    }

    public org.bukkit.inventory.Inventory getInventoryView() {
        return this.view;
    }

    @EventHandler(ignoreCancelled=true)
    public void inventoryCloseEvent(InventoryCloseEvent event) {
        if (!this.views.contains(event.getView())) {
            return;
        }
        ItemStack[] contents = event.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            this.contents[i] = contents[i];
            if (i != 0) continue;
            this.npc.getTrait(Equipment.class).setItemInHand(contents[i]);
        }
        if (this.npc.getEntity() instanceof InventoryHolder) {
            try {
                int maxSize = ((InventoryHolder)this.npc.getEntity()).getInventory().getStorageContents().length;
                ((InventoryHolder)this.npc.getEntity()).getInventory().setStorageContents(Arrays.copyOf(contents, maxSize));
            }
            catch (NoSuchMethodError e) {
                int maxSize = ((InventoryHolder)this.npc.getEntity()).getInventory().getContents().length;
                ((InventoryHolder)this.npc.getEntity()).getInventory().setContents(Arrays.copyOf(contents, maxSize));
            }
        }
        this.views.remove(event.getView());
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.contents = this.parseContents(key);
    }

    @Override
    public void onDespawn() {
        this.saveContents(this.npc.getEntity());
    }

    @Override
    public void onSpawn() {
        this.setContents(this.contents);
        int size = this.npc.getEntity() instanceof Player ? 36 : (this.npc.getEntity() instanceof InventoryHolder ? ((InventoryHolder)this.npc.getEntity()).getInventory().getSize() : this.contents.length);
        int rem = size % 9;
        if (rem != 0) {
            size += 9 - rem;
        }
        this.view = Bukkit.createInventory((InventoryHolder)(this.npc.getEntity() instanceof InventoryHolder ? (InventoryHolder)this.npc.getEntity() : null), (int)size, (String)(this.npc.getName() + "'s Inventory"));
    }

    public void openInventory(Player sender) {
        for (int i = 0; i < this.view.getSize(); ++i) {
            this.view.setItem(i, this.contents[i]);
        }
        this.views.add(sender.openInventory(this.view));
    }

    private ItemStack[] parseContents(DataKey key) throws NPCLoadException {
        ItemStack[] contents = new ItemStack[72];
        for (DataKey slotKey : key.getIntegerSubKeys()) {
            contents[Integer.parseInt((String)slotKey.name())] = ItemStorage.loadItemStack(slotKey);
        }
        return contents;
    }

    @Override
    public void run() {
        this.saveContents(this.npc.getEntity());
        Iterator<InventoryView> itr = this.views.iterator();
        while (itr.hasNext()) {
            InventoryView iview = itr.next();
            if (iview.getPlayer().isValid()) continue;
            iview.close();
            itr.remove();
        }
    }

    @Override
    public void save(DataKey key) {
        int slot = 0;
        for (ItemStack item : this.contents) {
            key.removeKey(String.valueOf(slot));
            if (item != null) {
                ItemStorage.saveItem(key.getRelative(String.valueOf(slot)), item);
            }
            ++slot;
        }
    }

    private void saveContents(Entity entity) {
        if (entity instanceof Player) {
            this.contents = ((Player)entity).getInventory().getContents();
            this.npc.getTrait(Equipment.class).setItemInHand(this.contents[0]);
        }
    }

    public void setContents(ItemStack[] contents) {
        this.contents = Arrays.copyOf(contents, 72);
        PlayerInventory dest = null;
        int maxCopySize = -1;
        if (this.npc.getEntity() instanceof Player) {
            dest = ((Player)this.npc.getEntity()).getInventory();
            maxCopySize = 36;
        } else if (this.npc.getEntity() instanceof StorageMinecart) {
            dest = ((StorageMinecart)this.npc.getEntity()).getInventory();
        } else if (this.npc.getEntity() instanceof Horse) {
            dest = ((Horse)this.npc.getEntity()).getInventory();
        }
        if (dest == null) {
            return;
        }
        if (maxCopySize == -1) {
            maxCopySize = dest.getSize();
        }
        for (int i = 0; i < maxCopySize; ++i) {
            dest.setItem(i, contents[i]);
        }
    }

    public void setItem(int slot, ItemStack item) {
        if (this.view != null && this.view.getSize() > slot) {
            this.view.setItem(slot, item);
        } else if (this.contents.length > slot) {
            this.contents[slot] = item;
        } else {
            throw new IndexOutOfBoundsException();
        }
        if (slot == 0) {
            this.npc.getTrait(Equipment.class).setItemInHand(item);
        }
    }

    void setItemInHand(ItemStack item) {
        if (this.view != null && this.view.getSize() > 0) {
            this.view.setItem(0, item);
        } else if (this.contents.length > 0) {
            this.contents[0] = item;
        }
    }

    public String toString() {
        return "Inventory{" + Arrays.toString(this.contents) + "}";
    }
}

