/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.goals;

import ch.ethz.globis.phtree.PhTreeSolid;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.util.Random;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;

public class WanderGoal
extends BehaviorGoalAdapter
implements Listener {
    private int delay;
    private int delayedTicks;
    private final Function<NPC, Location> fallback;
    private boolean forceFinish;
    private final NPC npc;
    private boolean paused;
    private final Random random = new Random();
    private final Supplier<PhTreeSolid<Boolean>> tree;
    private int xrange;
    private int yrange;

    private WanderGoal(NPC npc, int xrange, int yrange, Supplier<PhTreeSolid<Boolean>> tree, Function<NPC, Location> fallback) {
        this.npc = npc;
        this.xrange = xrange;
        this.yrange = yrange;
        this.tree = tree;
        this.fallback = fallback;
    }

    private Location findRandomPosition() {
        Location base = this.npc.getEntity().getLocation();
        Location found = null;
        for (int i = 0; i < 10; ++i) {
            int x = base.getBlockX() + this.random.nextInt(2 * this.xrange) - this.xrange;
            int y = base.getBlockY() + this.random.nextInt(2 * this.yrange) - this.yrange;
            int z = base.getBlockZ() + this.random.nextInt(2 * this.xrange) - this.xrange;
            Block block = base.getWorld().getBlockAt(x, y, z);
            if (!MinecraftBlockExaminer.canStandOn(block)) continue;
            long[] pt = new long[]{x, y, z};
            if (this.tree != null && this.tree.get() != null && !((PhTreeSolid)this.tree.get()).queryIntersect(pt, pt).hasNext()) continue;
            found = block.getLocation().add(0.0, 1.0, 0.0);
            break;
        }
        if (found == null && this.fallback != null) {
            return (Location)this.fallback.apply((Object)this.npc);
        }
        return found;
    }

    @EventHandler
    public void onFinish(NavigationCompleteEvent event) {
        this.forceFinish = true;
    }

    public void pause() {
        this.paused = true;
    }

    @Override
    public void reset() {
        this.delayedTicks = this.delay;
        this.forceFinish = false;
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public BehaviorStatus run() {
        if (!this.npc.getNavigator().isNavigating() || this.forceFinish) {
            return BehaviorStatus.SUCCESS;
        }
        return BehaviorStatus.RUNNING;
    }

    public void setDelay(int delay) {
        this.delay = delay;
        this.delayedTicks = delay;
    }

    public void setXYRange(int xrange, int yrange) {
        this.xrange = xrange;
        this.yrange = yrange;
    }

    @Override
    public boolean shouldExecute() {
        if (!this.npc.isSpawned() || this.npc.getNavigator().isNavigating() || this.paused) {
            return false;
        }
        if (this.delayedTicks-- > 0) {
            return false;
        }
        Location dest = this.findRandomPosition();
        if (dest == null) {
            return false;
        }
        this.npc.getNavigator().setTarget(dest);
        CitizensAPI.registerEvents(this);
        return true;
    }

    public void unpause() {
        this.paused = false;
    }

    public static WanderGoal createWithNPC(NPC npc) {
        return WanderGoal.createWithNPCAndRange(npc, 10, 2);
    }

    public static WanderGoal createWithNPCAndRange(NPC npc, int xrange, int yrange) {
        return WanderGoal.createWithNPCAndRangeAndTree(npc, xrange, yrange, null);
    }

    public static WanderGoal createWithNPCAndRangeAndTree(NPC npc, int xrange, int yrange, Supplier<PhTreeSolid<Boolean>> tree) {
        return WanderGoal.createWithNPCAndRangeAndTreeAndFallback(npc, xrange, yrange, tree, null);
    }

    public static WanderGoal createWithNPCAndRangeAndTreeAndFallback(NPC npc, int xrange, int yrange, Supplier<PhTreeSolid<Boolean>> tree, Function<NPC, Location> fallback) {
        return new WanderGoal(npc, xrange, yrange, tree, fallback);
    }
}

