/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Placeholders {
    private static Pattern PLAYER_MATCHER = Pattern.compile("<player>|<p>");

    public static String replace(String text, Player player) {
        text = PLAYER_MATCHER.matcher(text).replaceAll(player.getName());
        text = text.replace("<world>", player.getWorld().getName());
        try {
            PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return text;
    }

    public static String replace(String text, CommandSender sender, NPC npc) {
        if (sender instanceof Player) {
            text = Placeholders.replace(text, (Player)sender);
        }
        text = text.replace("<owner>", npc.getTrait(Owner.class).getOwner());
        text = text.replace("<npc>", npc.getName());
        text = text.replace("<id>", Integer.toString(npc.getId()));
        return text;
    }
}

