/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.flocking;

import java.util.Collection;
import net.citizensnpcs.api.ai.flocking.FlockBehavior;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.util.Vector;

public class SeparationBehavior
implements FlockBehavior {
    private final double decayCoef = 0.5;
    private final double maxAcceleration = 2.0;
    private final double weight;

    public SeparationBehavior(double weight) {
        this.weight = weight;
    }

    @Override
    public Vector getVector(NPC npc, Collection<NPC> nearby) {
        Vector steering = new Vector(0, 0, 0);
        Vector pos = npc.getEntity().getLocation().toVector();
        for (NPC neighbor : nearby) {
            if (!neighbor.isSpawned()) continue;
            double dist = neighbor.getEntity().getLocation().toVector().distanceSquared(pos);
            double strength = 0.5 / dist;
            if (strength > 2.0) {
                strength = 2.0;
            }
            steering = steering.add(steering.multiply(strength / Math.sqrt(dist)));
        }
        return steering.subtract(npc.getEntity().getVelocity()).multiply(this.weight);
    }
}

