/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import net.citizensnpcs.api.astar.AStarGoal;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.AStarStorage;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.SimpleAStarStorage;

public class AStarMachine<N extends AStarNode, P extends Plan> {
    private Supplier<AStarStorage> storageSupplier;

    private AStarMachine(Supplier<AStarStorage> storage) {
        this.storageSupplier = storage;
    }

    private void f(AStarGoal<N> goal, N node, N neighbour) {
        float g = ((AStarNode)node).g + goal.g(node, neighbour);
        float h = goal.h(neighbour);
        ((AStarNode)neighbour).f = g + h;
        ((AStarNode)neighbour).g = g;
        ((AStarNode)neighbour).h = h;
    }

    private AStarStorage getInitialisedStorage(AStarGoal<N> goal, N start) {
        AStarStorage storage = (AStarStorage)this.storageSupplier.get();
        storage.open((AStarNode)start);
        ((AStarNode)start).f = goal.getInitialCost(start);
        return storage;
    }

    public AStarState getStateFor(AStarGoal<N> goal, N start) {
        return new AStarState(this, goal, (AStarNode)start, this.getInitialisedStorage(goal, start));
    }

    public P run(AStarState state) {
        return this.run(state, -1);
    }

    public P run(AStarState state, int maxIterations) {
        return this.run(state.storage, state.goal, state.start, maxIterations);
    }

    private P run(AStarStorage storage, AStarGoal<N> goal, N start, int maxIterations) {
        Preconditions.checkNotNull(goal);
        Preconditions.checkNotNull(start);
        Preconditions.checkNotNull((Object)storage);
        int iterations = 0;
        do {
            AStarNode node;
            if ((node = storage.removeBestNode()) == null) {
                return null;
            }
            if (goal.isFinished(node)) {
                return (P)node.buildPlan();
            }
            storage.close(node);
            for (AStarNode neighbour : node.getNeighbours()) {
                this.f(goal, node, neighbour);
                if (!storage.shouldExamine(neighbour)) continue;
                storage.open(neighbour);
                neighbour.parent = node;
            }
        } while (maxIterations < 0 || iterations++ < maxIterations);
        return null;
    }

    public P runFully(AStarGoal<N> goal, N start) {
        return this.runFully(goal, start, -1);
    }

    public P runFully(AStarGoal<N> goal, N start, int iterations) {
        return this.run(this.getInitialisedStorage(goal, start), goal, start, iterations);
    }

    public void setStorageSupplier(Supplier<AStarStorage> newSupplier) {
        this.storageSupplier = newSupplier;
    }

    public static <N extends AStarNode, P extends Plan> AStarMachine<N, P> createWithDefaultStorage() {
        return AStarMachine.createWithStorage(SimpleAStarStorage.FACTORY);
    }

    public static <N extends AStarNode, P extends Plan> AStarMachine<N, P> createWithStorage(Supplier<AStarStorage> storageSupplier) {
        return new AStarMachine<N, P>(storageSupplier);
    }

    public static class AStarState {
        private final AStarGoal<N> goal;
        private final N start;
        private final AStarStorage storage;
        final /* synthetic */ AStarMachine this$0;

        private AStarState(AStarGoal<N> goal, N start, AStarStorage storage) {
            this.this$0 = this$0;
            this.goal = goal;
            this.start = start;
            this.storage = storage;
        }

        public N getBestNode() {
            return this.storage.getBestNode();
        }

        public boolean isEmpty() {
            return this.storage.getBestNode() == null;
        }
    }
}

