/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.gui;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.WeakHashMap;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuPattern;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.InventoryMenuTransition;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuPattern;
import net.citizensnpcs.api.gui.MenuSlot;
import net.citizensnpcs.api.gui.MenuTransition;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class InventoryMenu {
    private final Inventory inventory;
    private InventoryMenuPage page;
    private final InventoryMenuPattern[] patterns;
    private final InventoryMenuSlot[] slots;
    private final InventoryMenuTransition[] transitions;
    private static Map<Class<? extends InventoryMenuPage>, InventoryMenuInfo> CACHED_INFOS = new WeakHashMap<Class<? extends InventoryMenuPage>, InventoryMenuInfo>();

    public InventoryMenu(InventoryMenuInfo info) {
        int i;
        int[] dim = info.menuAnnotation.dimensions();
        int size = dim[0] * dim[1];
        this.inventory = info.menuAnnotation.type() == InventoryType.CHEST || info.menuAnnotation.type() == null ? Bukkit.createInventory(null, (int)size, (String)info.menuAnnotation.title()) : Bukkit.createInventory(null, (InventoryType)info.menuAnnotation.type(), (String)info.menuAnnotation.title());
        this.slots = new InventoryMenuSlot[this.inventory.getSize()];
        this.patterns = new InventoryMenuPattern[info.patterns.length];
        this.transitions = new InventoryMenuTransition[info.transitions.length];
        try {
            this.page = info.constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (i = 0; i < info.slots.length; ++i) {
            Bindable<MenuSlot> slotInfo = info.slots[i];
            int pos = ((MenuSlot)slotInfo.data).value()[0] * dim[0] + ((MenuSlot)slotInfo.data).value()[1];
            ((MenuSlot)slotInfo.data).value();
            InventoryMenuSlot inventoryMenuSlot = this.getSlot(pos);
        }
        for (i = 0; i < info.patterns.length; ++i) {
            Bindable<MenuPattern> patternInfo = info.patterns[i];
            InventoryMenuPattern inventoryMenuPattern = new InventoryMenuPattern();
        }
        for (i = 0; i < info.transitions.length; ++i) {
            Bindable<MenuTransition> bindable = info.transitions[i];
        }
    }

    private InventoryMenuSlot getSlot(int i) {
        return this.slots[i] == null ? new InventoryMenuSlot(this, i) : this.slots[i];
    }

    public static InventoryMenu create(Class<? extends InventoryMenuPage> clazz) {
        if (!CACHED_INFOS.containsKey(clazz)) {
            InventoryMenu.create0(clazz);
        }
        InventoryMenuInfo info = CACHED_INFOS.get(clazz);
        return new InventoryMenu(info);
    }

    private static void create0(Class<? extends InventoryMenuPage> clazz) {
        InventoryMenuInfo info = new InventoryMenuInfo();
        info.menuAnnotation = clazz.getAnnotation(Menu.class);
        if (info.menuAnnotation == null) {
            throw new IllegalArgumentException("Missing menu annotation");
        }
        try {
            Constructor<? extends InventoryMenuPage> found = clazz.getDeclaredConstructor(new Class[0]);
            found.setAccessible(true);
            info.constructor = found;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        CACHED_INFOS.put(clazz, info);
    }

    private static class InventoryMenuInfo {
        Constructor<? extends InventoryMenuPage> constructor;
        Menu menuAnnotation;
        Bindable<MenuPattern>[] patterns;
        Bindable<MenuSlot>[] slots;
        Bindable<MenuTransition>[] transitions;

        private InventoryMenuInfo() {
        }
    }

    private static class Bindable<T> {
        MethodHandle bind;
        T data;

        private Bindable() {
        }
    }
}

