/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.gui;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.gui.MenuSlot;
import net.citizensnpcs.api.util.Colorizer;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryMenuSlot {
    private Set<InventoryAction> actionFilter = EnumSet.allOf(InventoryAction.class);
    private final int index;
    private final Inventory inventory;

    InventoryMenuSlot(MenuContext menu, int i) {
        this.inventory = menu.getInventory();
        this.index = i;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InventoryMenuSlot other = (InventoryMenuSlot)obj;
        if (this.index != other.index) {
            return false;
        }
        return !(this.inventory == null ? other.inventory != null : !this.inventory.equals(other.inventory));
    }

    public Collection<InventoryAction> getFilter() {
        return this.actionFilter;
    }

    public int hashCode() {
        int result = 31 + this.index;
        return 31 * result + (this.inventory == null ? 0 : this.inventory.hashCode());
    }

    void initialise(MenuSlot data) {
        ItemStack defaultItem = null;
        if (data.material() != null) {
            defaultItem = new ItemStack(data.material(), data.amount());
        }
        if (defaultItem != null) {
            ItemMeta meta = defaultItem.getItemMeta();
            if (!data.lore().isEmpty()) {
                meta.setLore(Arrays.asList(Colorizer.parseColors(data.lore()).split("\\n|\n")));
            }
            if (!data.title().isEmpty()) {
                meta.setDisplayName(Colorizer.parseColors(data.title()));
            }
            defaultItem.setItemMeta(meta);
        }
        this.inventory.setItem(this.index, defaultItem);
        this.setFilter(Arrays.asList(data.filter()));
    }

    void onClick(InventoryClickEvent event) {
        if (!this.actionFilter.contains(event.getAction())) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
        }
    }

    public void setFilter(Collection<InventoryAction> filter) {
        this.actionFilter = filter == null || filter.isEmpty() ? EnumSet.allOf(InventoryAction.class) : EnumSet.copyOf(filter);
    }

    public void setItemStack(ItemStack stack) {
        this.inventory.setItem(this.index, stack);
    }
}

