/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.hpastar;

import ch.ethz.globis.phtree.PhTreeSolid;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.hpastar.AStarSolution;
import net.citizensnpcs.api.hpastar.Direction;
import net.citizensnpcs.api.hpastar.HPACluster;
import net.citizensnpcs.api.hpastar.HPAGraphAStarNode;
import net.citizensnpcs.api.hpastar.HPAGraphEdge;
import net.citizensnpcs.api.hpastar.HPAGraphNode;
import org.bukkit.Location;
import org.bukkit.Material;

public class HPAGraph {
    private final BlockSource blockSource;
    public List<List<HPACluster>> clusters = Lists.newArrayList();
    private final int cx;
    private final int cy;
    private final int cz;
    private final List<PhTreeSolid<HPACluster>> phtrees = Lists.newArrayList();
    private static int BASE_CLUSTER_SIZE = (int)(2.0 * Math.pow(2.0, 1.0));
    private static int MAX_CLUSTER_SIZE = (int)(2.0 * Math.pow(2.0, 7.0));
    private static int MAX_DEPTH = 3;

    public HPAGraph(BlockSource blockSource, int cx, int cy, int cz) {
        this.blockSource = blockSource;
        this.cx = cx;
        this.cy = cy;
        this.cz = cz;
    }

    public void addClusters(int x, int z) {
        int baseX = MAX_CLUSTER_SIZE * ((x - this.cx) / MAX_CLUSTER_SIZE) + this.cx;
        int baseZ = MAX_CLUSTER_SIZE * ((z - this.cz) / MAX_CLUSTER_SIZE) + this.cz;
        ArrayList<HPACluster> newClusters = new ArrayList<HPACluster>();
        if (this.phtrees.size() == 0) {
            this.phtrees.add((PhTreeSolid<HPACluster>)PhTreeSolid.create((int)3));
        }
        PhTreeSolid<HPACluster> baseTree = this.phtrees.get(0);
        int clusterSize = BASE_CLUSTER_SIZE / 2;
        for (int y = 0; y < 128; ++y) {
            for (int ci = 0; ci < MAX_CLUSTER_SIZE; ci += clusterSize) {
                for (int cj = 0; cj < MAX_CLUSTER_SIZE; cj += clusterSize) {
                    HPACluster cluster = new HPACluster(this, 0, clusterSize, y, baseX + ci, baseZ + cj);
                    newClusters.add(cluster);
                    baseTree.put(new long[]{cluster.clusterX, cluster.clusterY, cluster.clusterZ}, new long[]{cluster.clusterX + clusterSize, cluster.clusterY, cluster.clusterZ + clusterSize}, (Object)cluster);
                }
            }
        }
        IdentityHashMap clusterMap = new IdentityHashMap();
        for (HPACluster cluster : newClusters) {
            PhTreeSolid.PhQueryS q = baseTree.queryIntersect(new long[]{cluster.clusterX - clusterSize, cluster.clusterY - 1, cluster.clusterZ - clusterSize}, new long[]{cluster.clusterX + clusterSize, cluster.clusterY + 1, cluster.clusterZ + clusterSize});
            clusterMap.putIfAbsent(cluster, new ArrayList());
            while (q.hasNext()) {
                HPACluster neighbour = (HPACluster)q.nextValue();
                if (neighbour == cluster || ((List)clusterMap.get(cluster)).contains(neighbour) || neighbour.clusterX - cluster.clusterX != 0 && neighbour.clusterZ - cluster.clusterZ != 0) continue;
                int dx = neighbour.clusterX - cluster.clusterX;
                int dz = neighbour.clusterZ - cluster.clusterZ;
                Direction direction = null;
                if (dx > 0) {
                    direction = Direction.EAST;
                }
                if (dx < 0) {
                    direction = Direction.WEST;
                }
                if (dz > 0) {
                    direction = Direction.NORTH;
                }
                if (dz < 0) {
                    direction = Direction.SOUTH;
                }
                if (direction == null) continue;
                cluster.connect(neighbour, direction);
                clusterMap.putIfAbsent(neighbour, new ArrayList());
                ((List)clusterMap.get(cluster)).add(neighbour);
                ((List)clusterMap.get(neighbour)).add(cluster);
            }
        }
        for (HPACluster cluster : newClusters) {
            cluster.connectIntra();
        }
        this.addClustersAtDepth(0, newClusters);
        for (int depth = 1; depth <= MAX_DEPTH; ++depth) {
            newClusters = new ArrayList();
            clusterSize = (int)(2.0 * Math.pow(2.0, depth));
            for (int y = 0; y < 128; ++y) {
                for (int ci = 0; ci < MAX_CLUSTER_SIZE; ci += clusterSize) {
                    for (int cj = 0; cj < MAX_CLUSTER_SIZE; cj += clusterSize) {
                        HPACluster cluster = new HPACluster(this, depth, clusterSize, y, baseX + ci, baseZ + cj);
                        PhTreeSolid<HPACluster> lowerDepth = this.phtrees.get(depth - 1);
                        cluster.buildFrom(Lists.newArrayList((Iterator)lowerDepth.queryInclude(new long[]{cluster.clusterX - clusterSize, cluster.clusterY, cluster.clusterZ - clusterSize}, new long[]{cluster.clusterX + clusterSize, cluster.clusterY, cluster.clusterZ + clusterSize})));
                        newClusters.add(cluster);
                    }
                }
            }
            this.addClustersAtDepth(depth, newClusters);
        }
    }

    public void addClustersAtDepth(int depth, List<HPACluster> other) {
        while (this.clusters.size() <= depth) {
            this.clusters.add(new ArrayList());
            if (this.clusters.size() == this.phtrees.size()) continue;
            this.phtrees.add((PhTreeSolid<HPACluster>)PhTreeSolid.create((int)3));
        }
        this.clusters.get(depth).addAll(other);
    }

    public Plan findPath(Location start, Location goal) {
        ArrayList<HPACluster> clustersToClean = new ArrayList<HPACluster>();
        HPAGraphNode startNode = new HPAGraphNode(start.getBlockX(), start.getBlockY(), start.getBlockZ());
        HPAGraphNode goalNode = new HPAGraphNode(goal.getBlockX(), goal.getBlockY(), goal.getBlockZ());
        for (PhTreeSolid<HPACluster> phtree : this.phtrees) {
            HPACluster startCluster = (HPACluster)phtree.get(new long[]{start.getBlockX(), start.getBlockY(), start.getBlockZ()}, new long[]{start.getBlockX(), start.getBlockY(), start.getBlockZ()});
            HPACluster goalCluster = (HPACluster)phtree.get(new long[]{goal.getBlockX(), goal.getBlockY(), goal.getBlockZ()}, new long[]{goal.getBlockX(), goal.getBlockY(), goal.getBlockZ()});
            startCluster.insert(startNode);
            goalCluster.insert(goalNode);
            clustersToClean.add(startCluster);
            clustersToClean.add(goalCluster);
        }
        AStarSolution sln = this.pathfind(startNode, goalNode, 0);
        System.out.println(":" + start + "->" + goal + "=" + sln.cost);
        for (HPACluster cluster : clustersToClean) {
            cluster.remove(startNode, goalNode);
        }
        return new Path(sln.convertToVectors());
    }

    AStarSolution pathfind(HPAGraphNode start, HPAGraphNode dest, int level) {
        HashMap<HPAGraphAStarNode, Float> open = new HashMap<HPAGraphAStarNode, Float>();
        HashMap<HPAGraphAStarNode, Float> closed = new HashMap<HPAGraphAStarNode, Float>();
        PriorityQueue<HPAGraphAStarNode> frontier = new PriorityQueue<HPAGraphAStarNode>();
        HPAGraphAStarNode startNode = new HPAGraphAStarNode(start, null);
        frontier.add(startNode);
        open.put(startNode, Float.valueOf(startNode.g));
        while (!frontier.isEmpty()) {
            HPAGraphAStarNode node = (HPAGraphAStarNode)frontier.poll();
            List<HPAGraphEdge> edges = node.node.getEdges(level);
            for (HPAGraphEdge edge : edges) {
                if (!edge.to.equals(dest)) continue;
                return new AStarSolution(node.reconstructSolution(), node.g);
            }
            if (start != node.node) {
                closed.put(node, Float.valueOf(node.g));
            }
            open.remove(node);
            for (HPAGraphEdge edge : edges) {
                HPAGraphAStarNode neighbour = new HPAGraphAStarNode(edge.to, edge);
                if (closed.containsKey(neighbour)) continue;
                neighbour.parent = node;
                neighbour.g = node.g + edge.weight;
                neighbour.h = (float)Math.sqrt(Math.pow(edge.to.x - dest.x, 2.0) + Math.pow(edge.to.z - dest.z, 2.0));
                if (open.containsKey(neighbour)) {
                    if (neighbour.g > ((Float)open.get(neighbour)).floatValue()) continue;
                    frontier.remove(neighbour);
                }
                open.put(neighbour, Float.valueOf(neighbour.g));
                frontier.add(neighbour);
            }
        }
        return new AStarSolution(null, Float.POSITIVE_INFINITY);
    }

    public boolean walkable(int x, int y, int z) {
        if (y == 0) {
            return false;
        }
        Material in = this.blockSource.getMaterialAt(x, y, z);
        Material on = this.blockSource.getMaterialAt(x, y - 1, z);
        Material above = this.blockSource.getMaterialAt(x, y + 2, z);
        return MinecraftBlockExaminer.canStandOn(in) && MinecraftBlockExaminer.canStandIn(on) && MinecraftBlockExaminer.canStandIn(above);
    }
}

