/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.gui;

import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class CitizensInventoryClickEvent
extends InventoryClickEvent {
    private final InventoryClickEvent event;
    private final ItemStack result;

    public CitizensInventoryClickEvent(InventoryClickEvent event) {
        super(event.getView(), event.getSlotType(), event.getSlot(), event.getClick(), event.getAction(), event.getHotbarButton());
        this.event = event;
        this.result = this.getResult(event);
    }

    public ItemStack getCurrentItem() {
        return this.event.getCurrentItem() == null || this.event.getCurrentItem().getType() == Material.AIR ? null : this.event.getCurrentItem();
    }

    public ItemStack getCurrentItemNonNull() {
        return this.event.getCurrentItem() == null ? new ItemStack(Material.AIR, 0) : this.event.getCurrentItem();
    }

    public ItemStack getCursor() {
        return this.event.getCursor() == null || this.event.getCursor().getType() == Material.AIR ? null : this.event.getCursor();
    }

    public ItemStack getCursorNonNull() {
        return this.event.getCursor() == null ? new ItemStack(Material.AIR, 0) : this.event.getCursor();
    }

    private ItemStack getResult(InventoryClickEvent event) {
        ItemStack stack = event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR ? new ItemStack(event.getCursor().getType(), 0) : event.getCurrentItem().clone();
        switch (event.getAction()) {
            case PICKUP_ONE: {
                stack.setAmount(stack.getAmount() - 1);
                break;
            }
            case PICKUP_HALF: {
                stack.setAmount((int)Math.floor((double)stack.getAmount() / 2.0));
                break;
            }
            case PICKUP_ALL: {
                stack = null;
                break;
            }
            case PLACE_ALL: {
                stack.setAmount(Math.min(stack.getAmount() + event.getCursor().getAmount(), stack.getType().getMaxStackSize()));
                break;
            }
            case PLACE_SOME: {
                stack.setAmount(Math.min(stack.getAmount(), stack.getType().getMaxStackSize()));
                break;
            }
            case PLACE_ONE: {
                stack.setAmount(stack.getAmount() + 1);
                break;
            }
            default: {
                event.setCancelled(true);
                event.setResult(Event.Result.DENY);
                return null;
            }
        }
        return stack;
    }

    public ItemStack getResultItem() {
        return this.result;
    }

    public ItemStack getResultItemNonNull() {
        return this.result == null ? new ItemStack(Material.AIR, 0) : this.result;
    }

    public void setCancelled(boolean cancel) {
        this.event.setCancelled(cancel);
    }

    public void setCurrentItem(ItemStack item) {
        this.event.setCurrentItem(item);
    }

    public void setCursor(ItemStack cursor) {
        this.event.setCursor(cursor);
    }

    public void setResult(Event.Result result) {
        this.event.setResult(result);
    }
}

