/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Squid;
import org.bukkit.entity.WaterMob;
import org.bukkit.util.Vector;

public class SwimmingExaminer
implements BlockExaminer {
    private boolean canSwimInLava;
    private final NPC npc;
    private static final Vector UP = new Vector(0, 1, 0);

    public SwimmingExaminer(NPC npc) {
        this.npc = npc;
    }

    public boolean canSwimInLava() {
        return this.canSwimInLava;
    }

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        if (SwimmingExaminer.isWaterMob(this.npc.getEntity())) {
            Vector vector = point.getVector();
            if (!MinecraftBlockExaminer.isLiquidOrInLiquid(source.getWorld().getBlockAt(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ()))) {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        Vector vector = point.getVector();
        if (!MinecraftBlockExaminer.isLiquidOrInLiquid(source.getWorld().getBlockAt(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ()))) {
            return BlockExaminer.PassableState.IGNORE;
        }
        if (SwimmingExaminer.isWaterMob(this.npc.getEntity())) {
            return BlockExaminer.PassableState.PASSABLE;
        }
        Block block = source.getBlockAt(vector.clone().add(UP));
        return this.isSwimmableLiquid(block.getType()) || MinecraftBlockExaminer.canStandIn(block) ? BlockExaminer.PassableState.PASSABLE : BlockExaminer.PassableState.UNPASSABLE;
    }

    private boolean isSwimmableLiquid(Material material) {
        if (material == Material.LAVA || !SpigotUtil.isUsing1_13API() && material == Material.valueOf((String)"STATIONARY_LAVA")) {
            return this.canSwimInLava();
        }
        return material == Material.WATER || !SpigotUtil.isUsing1_13API() && material == Material.valueOf((String)"STATIONARY_WATER");
    }

    public boolean isSwimmingUp() {
        return this.npc.data().has(NPC.Metadata.SWIMMING) ? (Boolean)this.npc.data().get(NPC.Metadata.SWIMMING) : !SwimmingExaminer.isWaterMob(this.npc.getEntity());
    }

    public void setCanSwimInLava(boolean canSwimInLava) {
        this.canSwimInLava = canSwimInLava;
    }

    public static boolean isWaterMob(Entity entity) {
        if (!SpigotUtil.isUsing1_13API()) {
            return entity instanceof Squid;
        }
        return entity instanceof WaterMob || entity.getType().name().equals("TURTLE") || entity.getType().name().equals("FROG") || entity.getType().name().equals("AXOLOTL");
    }
}

