/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class MemoryDataKey
extends DataKey {
    private String name;
    private final ConfigurationSection root;

    public MemoryDataKey() {
        super("");
        this.root = new MemoryConfiguration();
    }

    private MemoryDataKey(ConfigurationSection root, String path) {
        super(path);
        this.root = root;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryDataKey other = (MemoryDataKey)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    @Override
    public boolean getBoolean(String key) {
        return this.root.getBoolean(this.getKeyFor(key), false);
    }

    @Override
    public double getDouble(String key) {
        return this.root.getDouble(this.getKeyFor(key), 0.0);
    }

    @Override
    public DataKey getFromRoot(String path) {
        return new MemoryDataKey(this.root, path);
    }

    @Override
    public int getInt(String key) {
        return this.root.getInt(this.getKeyFor(key), 0);
    }

    private String getKeyFor(String key) {
        if (key.isEmpty()) {
            return this.path;
        }
        if (key.charAt(0) == '.') {
            return this.path.isEmpty() ? key.substring(1, key.length()) : this.path + key;
        }
        return this.path.isEmpty() ? key : this.path + "." + key;
    }

    @Override
    public long getLong(String key) {
        return this.root.getLong(this.getKeyFor(key), 0L);
    }

    @Override
    public Object getRaw(String key) {
        return this.root.get(this.getKeyFor(key));
    }

    @Override
    public MemoryDataKey getRelative(String relative) {
        String key = this.getKeyFor(relative);
        return new MemoryDataKey(this.root, key);
    }

    @Override
    public String getString(String key) {
        return this.root.getString(this.getKeyFor(key), "");
    }

    @Override
    public Iterable<DataKey> getSubKeys() {
        ConfigurationSection head = this.root.getConfigurationSection(this.path);
        if (head == null) {
            return Collections.emptyList();
        }
        Set keys = head.getKeys(false);
        return Iterables.transform((Iterable)keys, (Function)new Function<String, DataKey>(){

            public DataKey apply(String input) {
                return new MemoryDataKey(MemoryDataKey.this.root, MemoryDataKey.this.getKeyFor(input));
            }
        });
    }

    @Override
    public Map<String, Object> getValuesDeep() {
        ConfigurationSection section = this.root.getConfigurationSection(this.path);
        if (section == null) {
            return Collections.emptyMap();
        }
        return section.getValues(true);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    @Override
    public boolean keyExists(String key) {
        return this.root.isSet(this.getKeyFor(key));
    }

    @Override
    public String name() {
        if (this.name == null) {
            int idx = this.path.lastIndexOf(46);
            this.name = idx == -1 ? this.path : this.path.substring(idx + 1, this.path.length());
        }
        return this.name;
    }

    @Override
    public void removeKey(String key) {
        this.set(key, null);
    }

    private void set(String key, Object value) {
        this.root.set(this.getKeyFor(key), value);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.set(key, value);
    }

    @Override
    public void setDouble(String key, double value) {
        this.set(key, value);
    }

    @Override
    public void setInt(String key, int value) {
        this.set(key, value);
    }

    @Override
    public void setLong(String key, long value) {
        this.set(key, value);
    }

    @Override
    public void setRaw(String key, Object value) {
        this.set(key, value);
    }

    @Override
    public void setString(String key, String value) {
        this.set(key, value);
    }

    public String toString() {
        return "MemoryDataKey[" + this.path + "]";
    }
}

