/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.citizensnpcs.api.npc.MetadataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.DataKey;

public class SimpleMetadataStore
implements MetadataStore {
    private final Map<String, MetadataObject> metadata = Maps.newHashMap();

    private void checkPrimitive(Object data) {
        boolean isPrimitive;
        Preconditions.checkNotNull((Object)data, (Object)"data cannot be null");
        boolean bl = isPrimitive = data instanceof String || data instanceof Boolean || data instanceof Number;
        if (!isPrimitive) {
            throw new IllegalArgumentException("data is not primitive");
        }
    }

    @Override
    public MetadataStore clone() {
        SimpleMetadataStore copy = new SimpleMetadataStore();
        copy.metadata.putAll(this.metadata);
        return copy;
    }

    @Override
    public <T> T get(NPC.Metadata key) {
        return this.get(key.getKey());
    }

    @Override
    public <T> T get(NPC.Metadata key, T def) {
        return this.get(key.getKey(), def);
    }

    @Override
    public <T> T get(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        MetadataObject normal = this.metadata.get(key);
        return (T)(normal == null ? null : normal.value);
    }

    @Override
    public <T> T get(String key, T def) {
        T t = this.get(key);
        if (t == null) {
            return def;
        }
        return t;
    }

    @Override
    public boolean has(NPC.Metadata key) {
        return this.has(key.getKey());
    }

    @Override
    public boolean has(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        return this.metadata.containsKey(key);
    }

    @Override
    public void loadFrom(DataKey key) {
        Iterator<Map.Entry<String, MetadataObject>> itr = this.metadata.entrySet().iterator();
        while (itr.hasNext()) {
            if (!itr.next().getValue().persistent) continue;
            itr.remove();
        }
        for (DataKey subKey : key.getSubKeys()) {
            this.setPersistent(subKey.name(), subKey.getRaw(""));
        }
    }

    @Override
    public void remove(String key) {
        this.metadata.remove(key);
    }

    @Override
    public void saveTo(DataKey key) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        for (Map.Entry<String, MetadataObject> entry : this.metadata.entrySet()) {
            if (!entry.getValue().persistent) continue;
            key.setRaw(entry.getKey(), entry.getValue().value);
        }
    }

    @Override
    public void set(NPC.Metadata key, Object data) {
        this.set(key.getKey(), data);
    }

    @Override
    public void set(String key, Object data) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        if (data == null) {
            this.remove(key);
        } else {
            this.metadata.put(key, new MetadataObject(data, false));
        }
    }

    @Override
    public void setPersistent(NPC.Metadata key, Object data) {
        this.setPersistent(key.getKey(), data);
    }

    @Override
    public void setPersistent(String key, Object data) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        this.checkPrimitive(data);
        this.metadata.put(key, new MetadataObject(data, true));
    }

    @Override
    public int size() {
        return this.metadata.size();
    }

    private static class MetadataObject {
        final boolean persistent;
        final Object value;

        public MetadataObject(Object raw, boolean persistent) {
            this.value = raw;
            this.persistent = persistent;
        }
    }
}

