/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;

public class Paginator {
    private boolean console;
    private String header;
    private final List<String> lines = new ArrayList<String>();
    private String pageCommand;
    private boolean pageSwitcher;
    private static final int LINES_PER_PAGE = 9;

    public Paginator() {
    }

    public Paginator(Collection<String> lines) {
        this.lines.addAll(lines);
    }

    public Paginator(int initialLinesOfText) {
        for (int i = 0; i < initialLinesOfText; ++i) {
            this.lines.add("");
        }
    }

    public void addLine(String line) {
        this.lines.add(line);
    }

    public Paginator console(boolean console) {
        this.console = console;
        return this;
    }

    public Paginator enablePageSwitcher() {
        this.pageSwitcher = true;
        this.pageCommand = "page $page";
        return this;
    }

    public Paginator enablePageSwitcher(String command) {
        this.pageSwitcher = true;
        this.pageCommand = command;
        return this;
    }

    public String getPageText(int page) {
        String text;
        int linesPerPage = this.console ? 200 : 9;
        int pages = (int)(Math.ceil((double)this.lines.size() / (double)linesPerPage) == 0.0 ? 1.0 : Math.ceil((double)this.lines.size() / (double)linesPerPage));
        if (page <= 0 || page > pages) {
            return null;
        }
        int startIndex = linesPerPage * page - linesPerPage;
        int endIndex = page * linesPerPage;
        String pageDisplay = page + "/" + pages;
        if (this.pageSwitcher) {
            if (page > 1) {
                pageDisplay = "<<<f>< :command(" + this.pageCommand.replace("$page", "" + (page - 1)) + "):Previous page>><f>" + pageDisplay;
            }
            if (pages > 1 && page != pages) {
                pageDisplay = pageDisplay + "<<<f> >:command(" + this.pageCommand.replace("$page", "" + (page + 1)) + "):Next page>>";
            }
        }
        String string = text = this.header == null ? "" : Paginator.wrapHeader("[[" + this.header + " <f>" + pageDisplay);
        if (this.lines.size() < endIndex) {
            endIndex = this.lines.size();
        }
        for (String line : this.lines.subList(startIndex, endIndex)) {
            text = text + "\n" + line;
        }
        return text;
    }

    public boolean hasPage(int page) {
        int linesPerPage = this.console ? 200 : 9;
        int pages = (int)(Math.ceil((double)this.lines.size() / (double)linesPerPage) == 0.0 ? 1.0 : Math.ceil((double)this.lines.size() / (double)linesPerPage));
        return page > 0 && page <= pages;
    }

    public Paginator header(String header) {
        this.header = header;
        return this;
    }

    public boolean sendPage(CommandSender sender, int page) {
        String text = this.getPageText(page);
        if (text != null) {
            Messaging.send(sender, text);
            return true;
        }
        return false;
    }

    public static String wrapHeader(Object string) {
        return "[[=====[ " + string.toString() + " [[]=====";
    }
}

