/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api;

import ch.ethz.globis.phtree.PhTreeF;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class LocationLookup
implements Runnable {
    private final Map<UUID, PhTreeF<Player>> worlds = Maps.newHashMap();

    public Iterable<Player> getNearbyPlayers(Location base, double dist) {
        PhTreeF<Player> tree = this.worlds.get(base.getWorld().getUID());
        if (tree == null) {
            return Collections.emptyList();
        }
        return () -> tree.rangeQuery(dist, new double[]{base.getX(), base.getY(), base.getZ()});
    }

    @Override
    public void run() {
        this.worlds.clear();
        for (World world : Bukkit.getServer().getWorlds()) {
            List players = world.getPlayers();
            if (players.isEmpty()) continue;
            PhTreeF tree = PhTreeF.create((int)3);
            this.worlds.put(world.getUID(), (PhTreeF<Player>)tree);
            Location loc = new Location(null, 0.0, 0.0, 0.0);
            for (Player player : players) {
                if (player.hasMetadata("NPC")) continue;
                player.getLocation(loc);
                tree.put(new double[]{loc.getX(), loc.getY(), loc.getZ()}, (Object)player);
            }
        }
    }
}

