/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.ItemStorage;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

@TraitName(value="equipment")
public class Equipment
extends Trait {
    private final ItemStack[] equipment = new ItemStack[6];
    private static boolean SUPPORT_OFFHAND = true;

    public Equipment() {
        super("equipment");
    }

    private ItemStack clone(ItemStack item) {
        return item == null || item.getType() == Material.AIR ? null : item.clone();
    }

    public ItemStack get(EquipmentSlot slot) {
        return this.get(slot.getIndex());
    }

    public ItemStack get(int slot) {
        if (this.npc.getEntity() instanceof Enderman && slot != 0) {
            throw new IllegalArgumentException("Slot must be 0 for enderman");
        }
        if (slot < 0 || slot > 5) {
            throw new IllegalArgumentException("Slot must be between 0 and 5");
        }
        return this.equipment[slot];
    }

    public ItemStack[] getEquipment() {
        return this.equipment;
    }

    public Map<EquipmentSlot, ItemStack> getEquipmentBySlot() {
        EnumMap map = Maps.newEnumMap(EquipmentSlot.class);
        map.put(EquipmentSlot.HAND, this.equipment[0]);
        map.put(EquipmentSlot.HELMET, this.equipment[1]);
        map.put(EquipmentSlot.CHESTPLATE, this.equipment[2]);
        map.put(EquipmentSlot.LEGGINGS, this.equipment[3]);
        map.put(EquipmentSlot.BOOTS, this.equipment[4]);
        map.put(EquipmentSlot.OFF_HAND, this.equipment[5]);
        return map;
    }

    private EntityEquipment getEquipmentFromEntity(Entity entity) {
        if (entity instanceof LivingEntity) {
            return ((LivingEntity)entity).getEquipment();
        }
        throw new RuntimeException("Unsupported entity equipment");
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        if (key.keyExists("hand")) {
            this.equipment[0] = ItemStorage.loadItemStack(key.getRelative("hand"));
        }
        if (key.keyExists("helmet")) {
            this.equipment[1] = ItemStorage.loadItemStack(key.getRelative("helmet"));
        }
        if (key.keyExists("chestplate")) {
            this.equipment[2] = ItemStorage.loadItemStack(key.getRelative("chestplate"));
        }
        if (key.keyExists("leggings")) {
            this.equipment[3] = ItemStorage.loadItemStack(key.getRelative("leggings"));
        }
        if (key.keyExists("boots")) {
            this.equipment[4] = ItemStorage.loadItemStack(key.getRelative("boots"));
        }
        if (key.keyExists("offhand")) {
            this.equipment[5] = ItemStorage.loadItemStack(key.getRelative("offhand"));
        }
    }

    @Override
    public void onAttach() {
        this.npc.scheduleUpdate(NPC.NPCUpdate.PACKET);
        this.run();
    }

    @Override
    public void onSpawn() {
        if (!(this.npc.getEntity() instanceof LivingEntity) && !(this.npc.getEntity() instanceof ArmorStand)) {
            return;
        }
        if (this.npc.getEntity() instanceof Enderman) {
            Enderman enderman = (Enderman)this.npc.getEntity();
            if (this.equipment[0] != null) {
                if (SpigotUtil.isUsing1_13API()) {
                    enderman.setCarriedBlock(this.equipment[0].getType().createBlockData());
                } else {
                    enderman.setCarriedMaterial(this.equipment[0].getData());
                }
            }
        } else {
            EntityEquipment equip = this.getEquipmentFromEntity(this.npc.getEntity());
            if (this.equipment[0] != null) {
                equip.setItemInHand(this.equipment[0]);
            }
            equip.setHelmet(this.equipment[1]);
            equip.setChestplate(this.equipment[2]);
            equip.setLeggings(this.equipment[3]);
            equip.setBoots(this.equipment[4]);
            try {
                equip.setItemInOffHand(this.equipment[5]);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        if (this.npc.getEntity() instanceof Player) {
            ((Player)this.npc.getEntity()).updateInventory();
        }
    }

    @Override
    public void run() {
        if (!(this.npc.getEntity() instanceof LivingEntity) || !this.npc.isUpdating(NPC.NPCUpdate.PACKET)) {
            return;
        }
        if (this.npc.getEntity() instanceof Enderman) {
            Enderman enderman = (Enderman)this.npc.getEntity();
            if (this.equipment[0] != null) {
                this.equipment[0] = SpigotUtil.isUsing1_13API() ? new ItemStack(enderman.getCarriedBlock().getMaterial(), 1) : enderman.getCarriedMaterial().toItemStack(1);
            }
        } else {
            EntityEquipment equip = this.getEquipmentFromEntity(this.npc.getEntity());
            this.equipment[0] = this.clone(equip.getItemInHand());
            this.equipment[1] = this.clone(equip.getHelmet());
            this.equipment[2] = this.clone(equip.getChestplate());
            this.equipment[3] = this.clone(equip.getLeggings());
            this.equipment[4] = this.clone(equip.getBoots());
            if (SUPPORT_OFFHAND) {
                try {
                    this.equipment[5] = this.clone(equip.getItemInOffHand());
                }
                catch (NoSuchMethodError e) {
                    SUPPORT_OFFHAND = false;
                }
            }
        }
    }

    @Override
    public void save(DataKey key) {
        this.saveOrRemove(key.getRelative("hand"), this.equipment[0]);
        this.saveOrRemove(key.getRelative("helmet"), this.equipment[1]);
        this.saveOrRemove(key.getRelative("chestplate"), this.equipment[2]);
        this.saveOrRemove(key.getRelative("leggings"), this.equipment[3]);
        this.saveOrRemove(key.getRelative("boots"), this.equipment[4]);
        this.saveOrRemove(key.getRelative("offhand"), this.equipment[5]);
    }

    private void saveOrRemove(DataKey key, ItemStack item) {
        if (item != null) {
            ItemStorage.saveItem(key, item);
        } else if (key.keyExists("")) {
            key.removeKey("");
        }
    }

    public void set(EquipmentSlot slot, ItemStack item) {
        this.set(slot.getIndex(), item);
    }

    public void set(int slot, ItemStack item) {
        if (item != null) {
            item = item.getType() == Material.AIR ? null : item.clone();
        }
        this.equipment[slot] = item;
        if (slot == 0) {
            this.npc.getOrAddTrait(Inventory.class).setItemInHand(item);
        }
        if (!(this.npc.getEntity() instanceof LivingEntity) && !(this.npc.getEntity() instanceof ArmorStand)) {
            return;
        }
        if (this.npc.getEntity() instanceof Enderman) {
            if (slot != 0) {
                throw new UnsupportedOperationException("Slot can only be 0 for enderman");
            }
            if (SpigotUtil.isUsing1_13API()) {
                ((Enderman)this.npc.getEntity()).setCarriedBlock(item.getType().createBlockData());
            } else {
                ((Enderman)this.npc.getEntity()).setCarriedMaterial(item.getData());
            }
        } else {
            EntityEquipment equip = this.getEquipmentFromEntity(this.npc.getEntity());
            switch (slot) {
                case 0: {
                    equip.setItemInHand(item);
                    break;
                }
                case 1: {
                    equip.setHelmet(item);
                    break;
                }
                case 2: {
                    equip.setChestplate(item);
                    break;
                }
                case 3: {
                    equip.setLeggings(item);
                    break;
                }
                case 4: {
                    equip.setBoots(item);
                    break;
                }
                case 5: {
                    if (!SUPPORT_OFFHAND) break;
                    try {
                        equip.setItemInOffHand(item);
                    }
                    catch (NoSuchMethodError e) {
                        SUPPORT_OFFHAND = false;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Slot must be between 0 and 5");
                }
            }
        }
        if (this.npc.getEntity() instanceof Player) {
            ((Player)this.npc.getEntity()).updateInventory();
        }
    }

    void setItemInHand(ItemStack item) {
        this.equipment[0] = item;
    }

    public String toString() {
        return "{hand=" + this.equipment[0] + ",helmet=" + this.equipment[1] + ",chestplate=" + this.equipment[2] + ",leggings=" + this.equipment[3] + ",boots=" + this.equipment[4] + ",offhand=" + this.equipment[5] + "}";
    }

    public static enum EquipmentSlot {
        BOOTS(4),
        CHESTPLATE(2),
        HAND(0),
        HELMET(1),
        LEGGINGS(3),
        OFF_HAND(5);

        private int index;

        private EquipmentSlot(int index) {
            this.index = index;
        }

        int getIndex() {
            return this.index;
        }
    }
}

