/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import org.bukkit.entity.Entity;

public class EntityDim {
    public final float height;
    public final float width;

    public EntityDim(double width, double height) {
        this((float)width, (float)height);
    }

    public EntityDim(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public EntityDim clone() {
        return new EntityDim(this.width, this.height);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityDim other = (EntityDim)obj;
        if (Double.doubleToLongBits(this.height) != Double.doubleToLongBits(other.height)) {
            return false;
        }
        return Double.doubleToLongBits(this.width) == Double.doubleToLongBits(other.width);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.height);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.width);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public EntityDim mul(float scale) {
        return new EntityDim(this.width * scale, this.height * scale);
    }

    public String toString() {
        return "EntityDim [height=" + this.height + ", width=" + this.width + "]";
    }

    public static EntityDim from(Entity entity) {
        return new EntityDim(entity.getWidth(), entity.getHeight());
    }
}

