/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import org.bukkit.entity.Player;

public class PermissionCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Action action = null;
        Player player = scriptEntry.getPlayer();
        String permission = null;
        String group = null;
        Object world = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("ADD, REMOVE", arg)) {
                action = Action.valueOf(aH.getStringFrom(arg).toUpperCase());
                continue;
            }
            if (aH.matchesValueArg("GROUP", arg, aH.ArgumentType.String)) {
                group = aH.getStringFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("WORLD", arg, aH.ArgumentType.String)) {
                group = aH.getStringFrom(arg);
                continue;
            }
            permission = arg;
        }
        scriptEntry.addObject("action", (Object)action).addObject("player", player).addObject("permission", permission).addObject("group", group).addObject("world", world);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        Player player = (Player)scriptEntry.getObject("player");
        String permission = String.valueOf(scriptEntry.getObject("permission"));
        String group = String.valueOf(scriptEntry.getObject("group"));
        String world = String.valueOf(scriptEntry.getObject("world"));
        if (group.equals("null")) {
            group = null;
        }
        if (world.equals("null")) {
            world = null;
        }
        dB.report(this.getName(), aH.debugObj("Action", action.toString()) + aH.debugObj("Player", player.getName()) + aH.debugObj("Permission", permission) + aH.debugObj("Group", group) + aH.debugObj("World", world));
        switch (action) {
            case ADD: {
                if (group != null) {
                    if (Depends.permissions.groupHas(world, group, permission)) {
                        dB.echoDebug("Group " + group + " already has permission " + permission);
                    } else {
                        Depends.permissions.groupAdd(world, group, permission);
                    }
                } else if (Depends.permissions.has(player, permission)) {
                    dB.echoDebug("Player " + player.getName() + " already has permission " + permission);
                } else {
                    Depends.permissions.playerAdd(player, permission);
                }
                return;
            }
            case REMOVE: {
                if (group != null) {
                    if (!Depends.permissions.groupHas(world, group, permission)) {
                        dB.echoDebug("Group " + group + " does not have access to permission " + permission);
                    } else {
                        Depends.permissions.groupRemove(world, group, permission);
                    }
                } else if (!Depends.permissions.has(player, permission)) {
                    dB.echoDebug("Player " + player.getName() + " does not have access to permission " + permission);
                } else {
                    Depends.permissions.playerRemove(world, player.getName(), permission);
                }
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        ADD,
        REMOVE;

    }
}

