/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.listeners.core.BlockListenerType;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.WorldGuardUtilities;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockListenerInstance
extends AbstractListener
implements Listener {
    BlockListenerType.BlockType type;
    List<String> blocks = new ArrayList<String>();
    Integer quantity = 1;
    String region = null;
    Integer currentBlocks = 0;
    List<Location> blocksBroken = new ArrayList<Location>();
    List<Integer> itemsCollected = new ArrayList<Integer>();
    List<Location> blocksPlaced = new ArrayList<Location>();

    @Override
    public void onBuild(List<String> args) {
        for (String arg : args) {
            if (aH.matchesValueArg("TYPE", arg, aH.ArgumentType.Custom)) {
                try {
                    this.type = BlockListenerType.BlockType.valueOf(aH.getStringFrom(arg).toUpperCase());
                    dB.echoDebug(dB.Messages.DEBUG_SET_TYPE, this.type.name());
                }
                catch (Exception e) {
                    dB.echoError("Invalid BlockType!");
                }
                continue;
            }
            if (aH.matchesQuantity(arg)) {
                this.quantity = aH.getIntegerFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_QUANTITY, String.valueOf(this.quantity));
                continue;
            }
            if (aH.matchesArg("BLOCKS, BLOCK", arg)) {
                this.blocks = aH.getListFrom(arg.toUpperCase());
                dB.echoDebug("...set BLOCK(S): " + Arrays.toString(this.blocks.toArray()));
                continue;
            }
            if (!aH.matchesValueArg("REGION", arg, aH.ArgumentType.Custom)) continue;
            this.region = aH.getStringFrom(arg);
            dB.echoDebug("...set REGION.");
        }
        if (this.blocks.isEmpty()) {
            dB.echoError("Missing BLOCK(S) argument!");
            this.cancel();
            return;
        }
        if (this.type == null) {
            dB.echoError("Missing TYPE argument! Valid: BUILD, COLLECT, BREAK");
            this.cancel();
        }
    }

    @Override
    public void onSave() {
        this.store("Type", this.type.name());
        this.store("Blocks", this.blocks);
        this.store("Quantity", this.quantity);
        this.store("Current Blocks", this.currentBlocks);
        this.store("Region", this.region);
    }

    @Override
    public void onLoad() {
        this.type = BlockListenerType.BlockType.valueOf((String)this.get("Type"));
        this.blocks = (List)this.get("Blocks");
        this.quantity = (Integer)this.get("Quantity");
        this.currentBlocks = (Integer)this.get("Current Blocks");
        this.region = (String)this.get("Region");
    }

    @Override
    public void onFinish() {
    }

    @Override
    public void onCancel() {
    }

    @Override
    public String report() {
        return null;
    }

    @Override
    public void constructed() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    @Override
    public void deconstructed() {
        BlockBreakEvent.getHandlerList().unregister((Listener)this);
        PlayerPickupItemEvent.getHandlerList().unregister((Listener)this);
        BlockPlaceEvent.getHandlerList().unregister((Listener)this);
    }

    public void check() {
        if (this.currentBlocks >= this.quantity) {
            this.finish();
        }
    }

    @EventHandler
    public void listenBreak(BlockBreakEvent event) {
        if (this.type == BlockListenerType.BlockType.BREAK && event.getPlayer() == this.player) {
            if (this.region != null && !WorldGuardUtilities.checkPlayerWGRegion(this.player, this.region)) {
                return;
            }
            if (this.blocks.contains(event.getBlock().getType().toString()) || this.blocks.contains(String.valueOf(event.getBlock().getTypeId()))) {
                if (this.blocksBroken.contains(event.getBlock().getLocation())) {
                    return;
                }
                this.blocksBroken.add(event.getBlock().getLocation());
                Integer n = this.currentBlocks;
                Integer n2 = this.currentBlocks = Integer.valueOf(this.currentBlocks + 1);
                dB.echoDebug(ChatColor.YELLOW + "// " + this.player.getName() + " broke a " + event.getBlock().getType().toString() + ".");
                this.check();
            }
        }
    }

    @EventHandler
    public void listenCollect(PlayerPickupItemEvent event) {
        if (this.type == BlockListenerType.BlockType.COLLECT && event.getPlayer() == this.player) {
            if (this.region != null && !WorldGuardUtilities.checkPlayerWGRegion(this.player, this.region)) {
                return;
            }
            if (this.blocks.contains(event.getItem().getItemStack().getType().toString()) || this.blocks.contains(String.valueOf(event.getItem().getItemStack().getTypeId()))) {
                if (this.itemsCollected.contains(event.getItem().getEntityId())) {
                    return;
                }
                this.itemsCollected.add(event.getItem().getEntityId());
                this.currentBlocks = this.currentBlocks + event.getItem().getItemStack().getAmount();
                dB.echoDebug(ChatColor.YELLOW + "// " + this.player.getName() + " collected a " + event.getItem().getItemStack().getType().toString() + ".");
                this.check();
            }
        }
    }

    @EventHandler
    public void listenBucket(PlayerBucketFillEvent event) {
        if (this.type == BlockListenerType.BlockType.COLLECT && event.getPlayer() == this.player) {
            if (this.region != null && !WorldGuardUtilities.checkPlayerWGRegion(this.player, this.region)) {
                return;
            }
            if (this.blocks.contains(event.getBucket().name().toUpperCase()) || this.blocks.contains(String.valueOf(event.getBucket().name().toUpperCase()))) {
                Integer n = this.currentBlocks;
                Integer n2 = this.currentBlocks = Integer.valueOf(this.currentBlocks + 1);
                dB.echoDebug(ChatColor.YELLOW + "// " + this.player.getName() + " collected a " + event.getBucket().name().toString() + ".");
                this.check();
            }
        }
    }

    @EventHandler
    public void listenPlace(BlockPlaceEvent event) {
        if (this.type == BlockListenerType.BlockType.BUILD && event.getPlayer() == this.player) {
            if (this.region != null && !WorldGuardUtilities.checkPlayerWGRegion(this.player, this.region)) {
                return;
            }
            if (this.blocks.contains(event.getBlock().getType().toString()) || this.blocks.contains(String.valueOf(event.getBlock().getTypeId()))) {
                if (this.blocksPlaced.contains(event.getBlock().getLocation())) {
                    return;
                }
                this.blocksPlaced.add(event.getBlock().getLocation());
                Integer n = this.currentBlocks;
                Integer n2 = this.currentBlocks = Integer.valueOf(this.currentBlocks + 1);
                dB.echoDebug(ChatColor.YELLOW + "// " + this.player.getName() + " placed a " + event.getBlock().getType().toString() + ".");
                this.check();
            }
        }
    }

    @EventHandler
    public void listenTag(ReplaceableTagEvent event) {
        if (!event.matches("LISTENER")) {
            return;
        }
        if (!event.getType().equalsIgnoreCase(this.listenerId)) {
            return;
        }
        if (event.getValue().equalsIgnoreCase("region")) {
            event.setReplaced(this.region);
        } else if (event.getValue().equalsIgnoreCase("quantity")) {
            event.setReplaced(this.quantity.toString());
        } else if (event.getValue().equalsIgnoreCase("currentblocks")) {
            event.setReplaced(this.currentBlocks.toString());
        } else if (event.getValue().equalsIgnoreCase("blocks")) {
            String blockList = "";
            for (String curTar : this.blocks) {
                blockList = blockList + curTar + ", ";
                blockList = blockList.substring(0, blockList.length() - 1);
            }
            event.setReplaced(blockList);
        }
    }
}

