/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.ExpUtil;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.entity.Player;

public class ExperienceCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        int amount = 0;
        Type type = Type.SET;
        boolean level = false;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesQuantity(arg) || aH.matchesInteger(arg)) {
                amount = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesArg("SET, GIVE, TAKE", arg)) {
                type = Type.valueOf(arg.toUpperCase());
                continue;
            }
            if (aH.matchesArg("LEVEL", arg)) {
                level = true;
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        scriptEntry.addObject("quantity", amount).addObject("type", (Object)type).addObject("level", level);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        Integer quantity = (Integer)scriptEntry.getObject("quantity");
        Boolean level = (Boolean)scriptEntry.getObject("level");
        dB.report(this.name, aH.debugObj("Type", type.toString()) + aH.debugObj("Quantity", level != false ? quantity.toString() + " levels" : quantity.toString()) + aH.debugObj("Player", scriptEntry.getPlayer().getName()));
        Player player = scriptEntry.getPlayer();
        switch (type) {
            case SET: {
                if (level.booleanValue()) {
                    ExpUtil.setLevel(player, quantity);
                    break;
                }
                ExpUtil.setTotalExperience(player, quantity);
                break;
            }
            case GIVE: {
                if (level.booleanValue()) {
                    ExpUtil.setLevel(player, player.getLevel() + quantity);
                    break;
                }
                ExpUtil.setTotalExperience(player, player.getTotalExperience() + quantity);
                break;
            }
            case TAKE: {
                if (level.booleanValue()) {
                    ExpUtil.setLevel(player, player.getLevel() - quantity);
                    break;
                }
                ExpUtil.setTotalExperience(player, player.getTotalExperience() - quantity);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        SET,
        GIVE,
        TAKE;

    }
}

