/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Scoreboard;

public class ScoreboardCommand
extends AbstractCommand {
    private Map<String, Scoreboard> scoreboards = new ConcurrentHashMap<String, Scoreboard>();

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Action action = null;
        String name = null;
        String id = null;
        Integer priority = null;
        Object show = null;
        String value = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesValueArg("SET", arg, aH.ArgumentType.Custom)) {
                action = Action.SET;
                name = aH.getStringFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("REMOVE", arg, aH.ArgumentType.Custom)) {
                action = Action.REMOVE;
                name = aH.getStringFrom(arg);
                continue;
            }
            if (aH.matchesValueArg("PRIORITY", arg, aH.ArgumentType.Integer)) {
                priority = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesArg("SHOW", arg)) {
                action = Action.SHOW;
                continue;
            }
            if (aH.matchesArg("HIDE", arg)) {
                action = Action.HIDE;
                continue;
            }
            if (aH.matchesValueArg("VALUE", arg, aH.ArgumentType.String)) {
                value = aH.getStringFrom(arg);
                continue;
            }
            id = aH.getStringFrom(arg);
        }
        scriptEntry.addObject("action", (Object)action).addObject("value", value).addObject("name", name).addObject("id", id).addObject("priority", priority).addObject("show", show);
    }

    private Scoreboard getScoreboard(String id) {
        for (String scoreboard_id : this.scoreboards.keySet()) {
            if (!scoreboard_id.equalsIgnoreCase(id)) continue;
            return this.scoreboards.get(scoreboard_id);
        }
        this.scoreboards.put(id, Bukkit.getScoreboardManager().getNewScoreboard());
        this.getScoreboard(id).registerNewTeam(id);
        return null;
    }

    private void removeScoreboard(String id) {
        for (String scoreboard_id : this.scoreboards.keySet()) {
            if (!scoreboard_id.equalsIgnoreCase(id)) continue;
            this.scoreboards.remove(scoreboard_id);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        String name = (String)scriptEntry.getObject("name");
        String value = (String)scriptEntry.getObject("value");
        Integer priority = (Integer)scriptEntry.getObject("priority");
        String id = (String)scriptEntry.getObject("id");
        dB.report(this.getName(), aH.debugObj("Action", action.toString()) + aH.debugObj("Id", id));
        switch (action) {
            case SET: {
                Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
                scoreboard.registerNewObjective(id, id);
                scoreboard.getObjective(id).setDisplaySlot(DisplaySlot.BELOW_NAME);
                scoreboard.getObjective(id).setDisplayName("display name");
                scoreboard.registerNewTeam(scriptEntry.getNPC().getName());
                scoreboard.getTeam(scriptEntry.getNPC().getName()).addPlayer((OfflinePlayer)((Player)scriptEntry.getNPC().getEntity()));
                break;
            }
            case REMOVE: {
                break;
            }
            case SHOW: {
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        SET,
        REMOVE,
        SHOW,
        HIDE;

    }
}

