/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.containers.core.TaskScriptContainer;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.arguments.Duration;
import net.aufdemrand.denizen.utilities.arguments.Script;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.arguments.dLocation;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ShootCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        EntityType entityType = null;
        dLocation location = null;
        Script newScript = null;
        Boolean ride = false;
        Boolean burn = false;
        double explosion = -1.0;
        Boolean fireworks = false;
        if (scriptEntry.getPlayer() != null) {
            location = new dLocation(scriptEntry.getPlayer().getLocation());
        }
        if (location == null && scriptEntry.getNPC() != null) {
            location = new dLocation(scriptEntry.getNPC().getLocation());
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesEntityType(arg)) {
                entityType = aH.getEntityFrom(arg);
                dB.echoDebug("...entity set to '%s'.", arg);
                continue;
            }
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                dB.echoDebug("...location set to '%s'.", arg);
                continue;
            }
            if (aH.matchesScript(arg)) {
                newScript = aH.getScriptFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_SCRIPT, arg);
                continue;
            }
            if (aH.matchesArg("ride, mount", arg)) {
                ride = true;
                dB.echoDebug("...will be mounted.");
                continue;
            }
            if (aH.matchesArg("burn, burning", arg)) {
                burn = true;
                dB.echoDebug("...will burn.");
                continue;
            }
            if (aH.matchesValueArg("explosion", arg, aH.ArgumentType.Double)) {
                explosion = aH.getDoubleFrom(arg);
                dB.echoDebug("...will have an explosion radius of " + explosion);
                continue;
            }
            if (aH.matchesArg("fireworks", arg)) {
                fireworks = true;
                dB.echoDebug("...will launch fireworks.");
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (entityType == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_INVALID_ENTITY);
        }
        scriptEntry.addObject("location", location);
        scriptEntry.addObject("script", newScript);
        scriptEntry.addObject("entityType", entityType);
        scriptEntry.addObject("ride", ride);
        scriptEntry.addObject("burn", burn);
        scriptEntry.addObject("explosion", explosion);
        scriptEntry.addObject("fireworks", fireworks);
    }

    public void execute(final ScriptEntry scriptEntry) throws CommandExecutionException {
        final dLocation location = scriptEntry.hasObject("location") ? (dLocation)scriptEntry.getObject("location") : (dLocation)scriptEntry.getNPC().getEyeLocation().getDirection().multiply(4).toLocation(scriptEntry.getNPC().getWorld());
        EntityType entityType = (EntityType)scriptEntry.getObject("entityType");
        Boolean ride = (Boolean)scriptEntry.getObject("ride");
        Boolean burn = (Boolean)scriptEntry.getObject("burn");
        if (location != null) {
            Utilities.faceLocation((Entity)scriptEntry.getNPC().getCitizen().getBukkitEntity(), location);
        }
        final Entity entity = scriptEntry.getNPC().getWorld().spawnEntity(scriptEntry.getNPC().getEyeLocation().add(scriptEntry.getNPC().getEyeLocation().getDirection()).subtract(0.0, 0.4, 0.0), entityType);
        Utilities.faceLocation(entity, location);
        if (ride.booleanValue()) {
            entity.setPassenger((Entity)scriptEntry.getPlayer());
        }
        if (burn.booleanValue()) {
            entity.setFireTicks(500);
        }
        if (entity instanceof Projectile) {
            ((Projectile)entity).setShooter(scriptEntry.getNPC().getCitizen().getBukkitEntity());
        }
        BukkitRunnable task = new BukkitRunnable(){
            int runs = 0;

            public void run() {
                if (this.runs < 40 && entity.isValid()) {
                    Vector v1 = entity.getLocation().toVector().clone();
                    Vector v2 = location.toVector().clone();
                    Vector v3 = v2.clone().subtract(v1).normalize().multiply(1.5);
                    entity.setVelocity(v3);
                    ++this.runs;
                    if (Math.abs(v2.getX() - v1.getX()) < 2.0 && Math.abs(v2.getY() - v1.getY()) < 2.0 && Math.abs(v2.getZ() - v1.getZ()) < 2.0) {
                        this.runs = 40;
                    }
                } else {
                    this.cancel();
                    this.runs = 0;
                    if (scriptEntry.getObject("script") != null) {
                        ((TaskScriptContainer)((Script)scriptEntry.getObject("script")).getContainer()).setSpeed(new Duration(Duration.valueOf(Settings.ScriptQueueSpeed()).getSeconds())).runTaskScript(scriptEntry.getPlayer(), scriptEntry.getNPC(), null);
                    }
                    if (((Boolean)scriptEntry.getObject("fireworks")).booleanValue()) {
                        Firework firework = (Firework)entity.getWorld().spawn(entity.getLocation(), Firework.class);
                        FireworkMeta fireworkMeta = firework.getFireworkMeta();
                        fireworkMeta.addEffects(new FireworkEffect[]{FireworkEffect.builder().withColor(Color.YELLOW).with(FireworkEffect.Type.STAR).build()});
                        fireworkMeta.setPower(2);
                        firework.setFireworkMeta(fireworkMeta);
                    }
                    if ((Double)scriptEntry.getObject("explosion") > 0.0) {
                        entity.getWorld().createExplosion(entity.getLocation(), ((Float)scriptEntry.getObject("explosion")).floatValue());
                    }
                }
            }
        };
        task.runTaskTimer((Plugin)this.denizen, 0L, 2L);
    }
}

